/*
 * Very simple ulimit processing. The only request that really makes any
 * sense right now is 3 which deals with the break region, the other values
 * we simply make up.
 */

#include "so.h"

static long _file_size_limit = 0x4000000;	/* arbitrarily large size */

long ulimit(cmd, newlimit)
int cmd;
long newlimit;
{
     switch (cmd) {
     case 1:	/* get file size limit */
	  return _file_size_limit;

     case 2:	/* set file size limit */
	  _file_size_limit = newlimit;
	  return newlimit;

     case 3:	/* get maximum break value */
	  return (long)BREAK_END_ADDR;

     case 4:	/* max open files */
	  return 0xFFFFFF;

     default:
	  warn("Bad cmd %d to ulimit()", cmd);
     }
}
