#ifndef _STDIO_H_INCLUDE
#define _STDIO_H_INCLUDE

#include "so.h"

/* Very Very Very minimal stdio package */

/*
 * Author:	Jordan K. Hubbard
 * Date:	April 25th, 1990.
 */

#define _FILE_READ	0x0100
#define _FILE_WRITE	0x0200
#define _FILE_MAPCR	0x0400
#define _FILE_DOEOF	0x0800
#define _FILE_ECHO	0x1000
#define _FILE_LINE	0x2000
#define _FILE_CBRK	(_FILE_MAPCR | _FILE_ECHO | _FILE_LINE)

#define EOF		-1

/*
 * This describes a simplistic FILE control block. I took a lot of shortcuts
 * to get this out quickly, don't take it as an example! (the ungetc()
 * handling (and buffer handling in general) is highly kludged).
 *
 * Real file handling would be better done in the context of a full
 * blown unix file system implementation and any further effort done at
 * this level would pretty much be wasted. Read the README file for more
 * details.
 */
typedef struct {
     int type;			/* various type flags */
     int unget;			/* for ungetc() */
     long start;		/* starting block address */
     long block;		/* The block we're currently reading/writing */
     int offset;		/* offset within the block */
     int length;		/* length of data in block */
     char *buffer;		/* file buffer */
} FILE;

/* Accessor macros */
#define _fp_type(fp)		(((FILE *)(fp))->type)
#define _fp_unget(fp)		(((FILE *)(fp))->unget)
#define _fp_start(fp)		(((FILE *)(fp))->start)
#define _fp_block(fp)		(((FILE *)(fp))->block)
#define _fp_offset(fp)		(((FILE *)(fp))->offset)
#define _fp_length(fp)		(((FILE *)(fp))->length)
#define _fp_buffer(fp)		(((FILE *)(fp))->buffer)

#define _eofchar(fp)		(_fp_type(fp) & 0x000000ff)

extern FILE *stdin, *stdout, *stderr;

extern void set_scsi_lun(int), set_scsi_addr(int), set_uart(int);
extern int fgetc(FILE *), getc(FILE *), getchar();
extern int fputc(int, FILE *), putc(int, FILE *), putchar();
extern int putw(int, FILE *), putl(long, FILE *), puth(int, FILE *);

extern char *fgets(char *, unsigned int, FILE *), *gets(char *);
extern void fputs(char *, FILE *), puts(char *);

extern FILE *fopen(long, char *);
extern int fread(char *, int, int, FILE *);
extern int fwrite(char *, int, int, FILE *);
extern int fseek(FILE *, long, long);
extern int ungetc(int, FILE *);

extern int printf(), fprintf(), fclose(FILE *);
extern void setbuf(FILE *, char *);
extern void fsetopt(int, FILE *);
extern void fclropt(int, FILE *);
extern void fflush(FILE *);

extern int block_read(long, char *);
extern int block_write(long, char *);

/* This shouldn't go here, but it has no home of its own */
extern char *malloc(int);

#endif /* _STDIO_H_INCLUDE */
