#include "so.h"

/*
 * Does Unix style mapping of cr to nl.  Probably should be used for all
 * terminal io rather than a direct db_fgetc().
 */
int getchar()
{
     int ret;

     if ((ret = db_fgetc(DEFAULT_UART)) == '\r')
	  return '\n';
     else
	  return ret;
}

/*
 * Converts nl to cr-lf, sends character to io.  Probably all other
 * routines want to use this as well.
 */
void putchar(x)
register int x;
{
     if (x == '\n')
	  db_fputc ('\r', DEFAULT_UART);
     db_fputc(x, DEFAULT_UART);
}

char *gets(s)
register char *s;
{
     register char ch;
     register int idx = 0;

     while ((ch = getchar()) != '\n') {
	  s[idx++] = ch;
	  putchar(ch);
     }
     putchar('\n');
     s[idx] = '\0';
     return(s);
}

void puts(s)
register char *s;
{
	while (*s)
		putchar(*(s++));
	putchar('\n');
}
