/*
 * Routines to implement a fake break region for malloc().
 *
 * Author:	Jordan K. Hubbard
 * Date:	April 27th, 1990.
 *
 */

#include "so.h"
#include "errno.h"

extern int errno, edata;
static char *_curr_brk = (char *)&edata;

int brk(addr)
char *addr;
{
     static int _init_done = 0;

     if (!_init_done) {
	  bzero(_curr_brk, BREAK_END_ADDR - _curr_brk);
	  _init_done = 1;
     }
     if (addr >= (char *)&edata && addr <= BREAK_END_ADDR) {
	  _curr_brk = addr;
	  return 0;
     }
     return(-1);
}

char *sbrk(inc)
int inc;
{
     char *old_addr;

     old_addr = _curr_brk;
     if (!brk(_curr_brk + inc))
	  return(old_addr);
     else
	  return (char *)-1;
}
