/*
 *	hex -- create intel hex from Un*x a.out (on a SUN)
 *	Copyright (C) 1988 Philip L. Budne
 *
 *	May be freely distributed and used for non-profit use only,
 *	provided this, and all other Copyright notices remain intact.
 *
 *	Commercial use is strictly forbidden without explicit, written
 *	permission of the author.
 */

# include <stdio.h>
# include <a.out.h>

struct exec a;
FILE *f;

extern char *optarg;
extern int optind;

int oflag = 0, eflag = 0, errs = 0, textonly = 0;

main( argc, argv )
    int argc;
    char *argv[];
{
    char *fname;
    int addr, addr2;
    register int i, c, n, reset, e;
    char buffer[ 100 ];
    register char *bp;

    while( (c = getopt( argc, argv, "a:oet" )) > 0 ) {
	switch( c ) {
	case 'a':
	    sscanf( "%x", optarg, addr );
	    break;
	case 'e':
	    eflag = 1;
	    break;
	case 'o':
	    oflag = 1;
	    break;
	case 't':
	    textonly = 1;
	    break;
	case '?':
	    errs++;
	}
    }

    if( optind >= argc || errs > 0  ) {
	fprintf( stderr, "Usage: %s [-o] [-e] a.out-file\n", argv[0] );
	exit( 1 );
    }

    if( !oflag && !eflag )
	oflag = eflag = 1;

    fname = argv[optind];
    if( (f = fopen( fname, "r" )) == NULL ) {
	perror( fname );
	exit( 1 );
    }

    if( fread( &a, sizeof( a ), 1, f ) != 1 ) {
	perror( "header fread" );
	exit( 1 );
    }

    if( N_BADMAG(a) ) {
	fprintf( stderr, "bad magic number %#o\n", a.a_magic );
	exit( 1 );
    }

    if( fseek( f, N_TXTOFF( a ), 0 ) < 0 ) {
	perror( "fseek" );
	exit( 1 );
    }

    reset = 1;
    if( textonly )
	e = a.a_text;
    else
	e = a.a_text + a.a_data;

    for( i = 0; i < e; i++ ) {
	if( (c = getc( f )) == EOF ) {
	    fprintf( stderr, "EOF in text at %d. of %d.\n", i, a.a_text );
	    exit( 1 );
	}

	if( (i & 1) == 0 ) {
	    if( !eflag )		/* is even -- print even bytes? */
		continue;		/* no. */
	}
	else if( !oflag )		/* is odd -- print odd bytes? */
	    continue;

	if( reset ) {
	    n = 0;
	    bp = buffer;
	    reset = 0;
	    addr2 = addr;
	}
	*bp++ = c;

	n++;
	addr++;
	if( n == 16 ) {
	    orec( addr2, n, buffer );
	    reset = 1;
	}
    } /* for */

    if( reset )
	n = 0;

    if(  n != 0 )
	orec( addr2, n, buffer );
    
    printf(":%02X%04X%02X", 0, /*a.a_entry*/0, 1 );
    printf("%02X\n", (-(1)) & 0xff );

    fclose( f );
}

orec( addr, n, bp )
    int n;
    register char *bp;
{
    register unsigned sum, ch, outsum;

    n &= 0xff;
    sum = n + ((addr >> 8) & 0xff) + (addr & 0xff);

    printf( ":%02X%04X%02X", n, addr, 0 );
    while( n-- > 0 ) {
	printf( "%02X", (ch = *bp++) & 0xff );
	sum += ch;
    }

    outsum = -(sum & 0xff);
    printf( "%02X\n", outsum & 0xff );
}
