/* sendpack.c - sendpack, putw, putch, putwsum putlsum, putchar */

#include "define.h"

union	fourbyte {
	long	l;
	short	s[2];
	char	c[4];
};

/*----------------------------------------------------------------------------
 * sendpack - send a packet to the MC 68000
 *----------------------------------------------------------------------------
 */

unsigned long sum;
extern int MONTTY;
extern int debug;

monchar(c)
    char c;
{
    char buf[1];
    if( debug )
	fprintf( logfp, "%x ", c & 0xff );
    buf[0] = c;
    write( MONTTY, buf, 1);
}

sendpack(addr, length, buf)
	long	addr;			/* starting address		*/
	long	length;			/* length of data in bytes	*/
	char	*buf;			/* data output buffer		*/
{
	int	i, j;

	if( A.verbose )
	    fprintf(logfp,"Sending packet to address 0x%x, of length 0x%x\n",
		    addr, length);
	monchar(SOH);
	sum = 0;
	putlsum(addr);
	putlsum(length);
	for ( i=0 ; i<length ; i++ )
		putch(buf[i]);
        putlsum(~sum);
	fflush( logfp );
}

/*---------------------------------------------------------------------------
 * putch - put a character on the high speed line
 *---------------------------------------------------------------------------
 */
putch(ch)
    unsigned char ch;
{
    sum += ch;
    if ( ch == ESC || ch == SOH )
	monchar(ESC);
    monchar(ch);
}

/*----------------------------------------------------------------------------
 * putlsum - write a fourbyte to the high speed line (4 bytes)
 *----------------------------------------------------------------------------
 */
putlsum(x)
long	x;
{
	union	fourbyte y;

	y.l = x;
#ifdef vax
	putch(y.c[3] & 0xff);
	putch(y.c[2] & 0xff);
	putch(y.c[1] & 0xff);
	putch(y.c[0] & 0xff);
#endif
#ifdef mc68000
	putch(y.c[0] & 0xff);
	putch(y.c[1] & 0xff);
	putch(y.c[2] & 0xff);
	putch(y.c[3] & 0xff);
#endif
	return;
}
