/* sendmon.c - sendmon */
#include <stdio.h>
#include "define.h"

/*------------------------------------------------------------------------------
 * sendmon  --  send a message to the monitor
 *------------------------------------------------------------------------------
 */
extern int MONTTY;
extern int debug;

sendmon(msg, wait)
	char *msg;
	Bool wait;
{
	char buf[32], *ptr, tmpstr[2];

	if( debug ) {
	    fprintf( stderr, "sendmon: " );
	    dumpstr( msg );
	    fprintf( stderr, "\n" );
	}

	while (*msg!=EOS) {
		write(MONTTY, msg, 1);
		usleep( 10 * 1000 );
                if ( wait ) {
                        tmpstr[0] = *msg;
                        tmpstr[1] = EOS;
                        readuntil(tmpstr, buf, 5);
                }
		msg++;
	}
}

dumpstr( s )
char *s;
{
    char c;

    while( (c = (*s++) & 0177) != '\0' ) {
	dumpchar( c );
    }
}

dumpchar( c )
    char c;
{
    if( c >= ' ' && c < 0177 )
	putc( c, stderr );
    else
	switch( c ) {
	case '\b':
	    fprintf( stderr, "\\b" );
	    break;
	case '\n':
	    fprintf( stderr, "\\n" );
	    break;
	case '\r':
	    fprintf( stderr, "\\r" );
	    break;
	case '\t':
	    fprintf( stderr, "\\t" );
	    break;
	default:
	    fprintf( stderr, "\\%03o", c );
	}
}
