/* readuntil.c - readuntil */

#include <stdio.h>
#include <errno.h>
#include "define.h"

/*-----------------------------------------------------------------------------
 * readuntil - read from line until some set of characters has been sent
 *-----------------------------------------------------------------------------
 */
extern int MONTTY;
extern int debug;

readuntil ( ch, buf, time )
	char	*ch;			/* The char. string to expect	*/
	char	*buf;			/* The buffer of incoming chs	*/
	int	time;			/* Seconds till timeout		*/
{
	if( debug ) {
	    fprintf( stderr, "readuntil ``" );
	    dumpstr( ch );
	    fprintf( stderr, "'' wait %d\n", time );
	    fprintf( stderr, "{" );
	}
	alarm(time);

	do {
		do {
			*buf = EOS;
			if ( read(MONTTY, buf, 1) != 1 )
				error("SUN did not respond\n", NULL);
			if( debug )
			    dumpchar( *buf );
		} while ( *buf == EOS || index(ch,*buf++) == NULL );
	} while ( *++ch != EOS);
	*buf = EOS;
	alarm(0);
	if( debug )
	    fprintf( stderr, "}\n" );
}
