/* loadprog.c - loadprog */

#include <a.out.h>
#include "define.h"

#undef PACKSIZE
#define PACKSIZE 32

char Fastbuf[BUFSIZ];

/*------------------------------------------------------------------------------
 * loadprog - load user program over high speed line
 *------------------------------------------------------------------------------
 */
extern int MONTTY, debug;

loadprog(userfp, userhdr, loadaddr, fastlength)
FILE	*userfp;
struct	exec	*userhdr;
int	loadaddr;
int	fastlength;
{
	int	bytes, cnt, ocnt;
	int	length;
	char	buf[ 2048 ];
	char	resp;

	bytes = userhdr->a_text + userhdr->a_data;
	setbuf(stdout, Fastbuf);
	cnt = ocnt = -1;
	while( bytes > 0 ) {
	    cnt = bytes >> 8 ;
	    if( cnt != ocnt ) {
	        fprintf(stderr, "\r%6d", bytes );
		ocnt = cnt;
	    }
	    length = (bytes>PACKSIZE ? PACKSIZE : bytes);
	    fread(buf, 1 , length, userfp);
	    do {
		sendpack(loadaddr,length,buf);
		alarm(10);
		do {
		    if ( read ( MONTTY, &resp, 1) != 1 ) 
			resp = 'T';
		} while( resp == 's' );
		alarm(0);
		if( debug )
		    fprintf( stderr, "resp = %d. '%c'\n",
			    resp&0xff, resp );
		if ( resp == NAK )
		    message("NAK");
	    } while ( resp != ACK );
	    loadaddr += length;
	    bytes -= length;
	}
	sendpack ( loadaddr, 0, buf );
	alarm(4);
	if ( read ( MONTTY, &resp, 1) != 1 ) 
		resp = 'T';
	alarm(0);
	fprintf( stderr, "\r      \r" );
	message("Done loading user program");
}
