/* loadfast.c - loadfast */

#include <a.out.h>
#include "define.h"

#define	LENADDR	0xffe

/*----------------------------------------------------------------------------
 *  loadfast --  send fast loader to boot loader in reverse order
 *----------------------------------------------------------------------------
 */
extern int MONTTY;
# define FASTADDR (0x200000+0xfc00)

loadfast(fastfp, fasthdr)
	FILE	*fastfp;
	struct	exec	*fasthdr;
{

	unsigned  addr;
	int	bytes, length;
	char	buf[256];

# define MAXBUF 256			/* seems to work */

	bytes = fasthdr->a_text + fasthdr->a_data;	
	addr = FASTADDR;
	while( bytes > 0 ) {
	    length = (bytes > MAXBUF ? MAXBUF : bytes);
	    sprintf( buf, "s%x,%x\r", addr, length ); /* store raw binary */
	    sendmon( buf, NOWAIT );
	    readuntil( "=", buf, 1 );

	    if( fread(buf, 1 , length, fastfp ) != length )
		perror( "fread" );
	    if( write( MONTTY, buf, length ) < 0 )
		perror( "write" );
	    addr += length;
	    bytes -= length;
	    readuntil( ">", buf, 1 );
	}
	sprintf( buf, "g%x\r", FASTADDR );
	sendmon( buf, NOWAIT );
	readuntil( "\n", buf, 5 );
	return;
}
