/* getmon.c - getmon, restore */

#include "define.h"
#include <sgtty.h>

struct	sgttyb	oldtty, newtty;

/*----------------------------------------------------------------------------
 * getmon  --  set linemode options and wait for monitor prompt.
 *             executed directly after monitor 'L' command.
 *----------------------------------------------------------------------------
 */

extern int MONTTY;
getmon()
{
        char buf[BUFSIZ];

	gtty(MONTTY, &oldtty);
	ttyset = TRUE;
	gtty(MONTTY, &newtty);
	newtty.sg_flags |=  RAW;
	newtty.sg_flags &= ~ECHO;
	stty(MONTTY, &newtty);
	sendmon("\r", NOWAIT);
	readuntil(">", buf, 10);
}

/*----------------------------------------------------------------------------
 *  restore  --  restore terminal line to previous state
 *----------------------------------------------------------------------------
 */
restore()
{
    if (ttyset)
	stty(MONTTY, &oldtty);
}
