|	MC68010 Tiny Monitor -- vector test - trap all vectors and print
|	Copyright (C) 1988 Philip L. Budne
|
|	May be freely distributed and used for non-profit use only,
|	provided this, and all other Copyright notices remain intact.
|
|	Commercial use is strictly forbidden without explicit, written
|	permission of the author.
|
	.data

| requires static storage!!

	.comm	vectab,256
	.comm	regsave,16

	.text
	.globl	_vtest
_vtest:
	lea	vectab,a1			| get vector table
	movc	a1,vbr				| set CPU vector base register
	movl	#255,d0
10$:	movl	#myint,a1@+
	dbra	d0,10$

20$:	stop	#0x2000
	bra	20$

	rts

| 68010 frame:
| sp+0	sr
| sp+2	pc.h
| sp+4	pc.l
| sp+6	format/vector
| 	......

myint:
	moveml	#0xffff,regsave
	movw	sp@(6),d0			| get format + vector

	andl	#0x0fff,d0			| isolate vector addrress
	lsrl	#2,d0				| make vector number

	btst	#15,sp@(6)			| test for long frame
	bne	20$
	
	movw	#0,sp@-				| make status look long
	movl	d0,sp@-				| push vector
	pea	mymsg
	jsr	_sa_printf
	addl	#10,sp

	bra	30$

| here on address exception...
20$:	movl	sp@(10),d1			| get address
	movw	#0,sp@-				| make status look long
	movl	d1,sp@-				| push address
	movl	d0,sp@-				| push vector
	pea	mymsg2
	jsr	_sa_printf
	addl	#14,sp

30$:	rte

|	.data

	.even
mymsg:	.asciz 	"Trap: Vector %d. sr %#x pc %#x\12\15"

	.even
mymsg2:	.asciz 	"Trap: Vector %d. addr %#x sr %#x pc %#x\12\15"
