|	MC68010 Tiny Monitor -- startup code
|	Copyright (C) 1988 Philip L. Budne
|
|	May be freely distributed and used for non-profit use only,
|	provided this, and all other Copyright notices remain intact.
|
|	Commercial use is strictly forbidden without explicit, written
|	permission of the author.

| ROM at 0, never relocated.
|	all i/o is polled.
|	interrupts when activated must be related via vbr.

| 64K Static ram
K=1024
NK=63
SRAM= 0x200000

| MC68681 DUART
DUART=0xfc0001

MR1A=DUART+0
MR2A=DUART+0

SRA=DUART+2
CSRA=DUART+2

CRA=DUART+4

TBA=DUART+6
RBA=DUART+6

ACR=DUART+8

CR=0x0d
LF=0x0a
SP=0x20				| ' '
DOT=0x2E			| '.'
EFF=0x46			| 'F'
GEE=0x47			| 'G'


	.text
	.globl	_start
	.globl	_verstr

	.long	0		| initial SSP
	.long	_start		| initial PC

_start:	movw	#0x2700,sr	| no trace, supervisor, interrupt mask=7

	reset			| zap all devices

| reset MC68681 DUART channel A only
	movb	#0x10,CRA	| reset mr pointer to mr1
	movb	#0x00,ACR	| baud rate set 1, counter mode ext, ints disa
	movb	#0xbb,CSRA	| rx & tx at 9600 baud
	movb	#0x13,MR1A	| no rx rts, no rx irq, char er, none, even, 8
	movb	#0x0f,MR2A	| normal, no tx rts, no tx cts, 2 stop
	movb	#0x05,CRA	| none, ena tx, ena rx

	movl	#1000,d0
slow:	nop			| waste a little time before doing i/o
	dbra	d0,slow

	lea	banner,a1
10$:	btst	#2,SRA
	beq	10$
	movb	a1@+,TBA
	bne	10$

	lea	_verstr,a1
20$:	btst	#2,SRA
	beq	20$
	movb	a1@+,TBA
	bne	20$

	clrb	d2		| first pass, clear flag

	lea	SRAM,a1		| SRAM base
	movl	#NK,d1		| 64k of SRAM
kloop:	movb	a1@,d0		| get long
	movb	d0,d3		| save original
	notb	d0		| flip bits
	movb	d0,a1@		| store back
	movb	a1@,d7		| read again
	movb	d3,a1@		| restore to original
	cmpb	d0,d7		| same as we wrote??
	bne	10$		| grrrr

	movb	#DOT,d3
	bra	20$
10$:	movb	#EFF,d3
20$:	btst	#2,SRA		| spin on Tx ready
	beq	20$
	movb	d3,TBA		| print char

	lea	a1@(K),a1	| bump pointer by 1k
	dbra	d1,kloop

memok:	btst	#2,SRA
	beq	memok
	movb	#CR,TBA
10$:	btst	#2,SRA
	beq	10$
	movb	#LF,TBA

	tstb	d2		| first time thru?
	bne	memdone		| no. we are done.

	notb	d2		| yes. flip bits in flag.
	lea	SRAM+1,a1	| do it again, odd bytes
	movl	#NK,d1		| all 64k
	bra	kloop		| start again

memdone:
	lea	memmsg,a2
10$:	btst	#2,SRA
	beq	10$
	movb	a2@+,TBA
	bne	10$

|****************************************************************

	lea	SRAM+0xfbfe, sp	| get a stack pointer (reserve top 1k)
	jsr	_newmon		| call tiny monitor
	bra	_start		| be dull again (if we return)

	.even
banner:	.byte	CR,LF
	.ascii	"MC68010 Tiny Monitor Version 2.0"
	.byte	CR,LF
	.ascii	"Copyright (C) 1988 Philip L. Budne"
	.byte	0

	.even
memmsg:	.byte	CR,LF
	.ascii	"Memory OK."
	.byte	CR,LF,0
