/*
 * serial line packet loader.
 * USES NO STATIC STORAGE!
 */

# define PACKSIZE 1024

# define SOH	'/'
# define START	's'
# define ACK	'y'
# define NAK	'n'
# define ESC	'\033'			/* ESCAPE */

/*
# include "sa_io.h"
*/
extern unsigned int rawgetc();

unsigned int getcsum();
unsigned int getwsum();
unsigned long getlsum();
static unsigned int getc();

do_loader() {
    unsigned register c;
    unsigned long PackLen, CheckSum, Sum2, BaseAddr;
    unsigned char Buffer[ PACKSIZE ];

    for( ; ; ) {			/* getpack */
	c = rawgetc();
	for( ; ; ) {			/* loop for SOH */
	    if( c == SOH )
		break;

# define LOW7(x) ((x)&0177)
	    if( LOW7(c) == 'Q' &&
	       LOW7(c = rawgetc()) == 'U' &&
	       LOW7(c = rawgetc()) == 'I' &&
	       LOW7(c = rawgetc()) == 'T' )
		return( 0 );
	}

	/* getbase */
	CheckSum = 0;
	BaseAddr = getlsum(&CheckSum);

	/* getlen */
	PackLen = getlsum(&CheckSum);

	/* chkrange */
	if( PackLen > PACKSIZE ) {
	    putchar( NAK );
	    continue;
	}

	/* copyvars */
	if( PackLen != 0 ) {
	    unsigned char register *cp;
	    long register i;

	    /* getbuf */
	    cp = Buffer;
	    i = PackLen;
	    while( i-- > 0 )
		*cp++ = getcsum(&CheckSum);
	}

	/* getsum */
	Sum2 = getc();
	Sum2 <<= 8;
	Sum2 |= getc();
	Sum2 <<= 8;
	Sum2 |= getc();
	Sum2 <<= 8;
	Sum2 |= getc();
	if( Sum2 & CheckSum ) {		/* checksum sent ones complement */
	    putchar( NAK );
	    continue;
	}

	if( PackLen != 0 )
	    bcopy( Buffer, (char *)BaseAddr, PackLen );

	putchar( ACK );
	if( PackLen == 0 )
	    return( 1 );
    } /* for ever */
} /* loader */

unsigned getcsum(a)
unsigned long *a;
{
    unsigned register i;
    i = rawgetc();
    *a += i;
    return( i );
}

unsigned int getwsum(a)
unsigned long *a;
{
    unsigned char register i;
    i = getcsum(a);
    return( (i << 8) | getcsum(a) );
}

unsigned long getlsum( a )
unsigned long *a;
{
    unsigned short register i;

    i = getwsum(a);
    return( (i << 16) | getwsum(a) );
}

static unsigned
getc() {
    register c;
    c = rawgetc();
    if( c == ESC )
	c = rawgetc();
    return( c );
}
