|	MC68010 Tiny Monitor -- DUART interrupt test
|	Copyright (C) 1988 Philip L. Budne
|
|	May be freely distributed and used for non-profit use only,
|	provided this, and all other Copyright notices remain intact.
|
|	Commercial use is strictly forbidden without explicit, written
|	permission of the author.

DUART=0xfc0000+1

MR1A=DUART+0
MR2A=DUART+0

SRA=DUART+2
CSRA=DUART+2

CRA=DUART+4

TBA=DUART+6
RBA=DUART+6

ACR=DUART+8

IMR=DUART+10			| WO
ISR=DUART+10			| RO

CTUR=DUART+12			| WO

CTLR=DUART+14			| WO

IVR=DUART+24			| RW !!

OPCR=DUART+26			| WO

TSTART=DUART+28			| READ (ADDR TRIGGER)

MYVEC=0x0f
STAR=0x2a
BANG=0x21
ZERO=0x30
ONE=ZERO+1
TWO=ONE+1

TABLE=0x202000			| RAM location of vectors
	.text
	.globl	_itest

_itest:
|	movl	#TABLE-4,sp
	movl	#0x20bffe,sp
	movl	#TABLE,a1
	movec	a1,vbr

	movl	#255,d0
setup:	movl	#star,a1@+
	dbra	d0,setup

	movl	#isr,TABLE+(MYVEC*4)

10$:	btst	#2,SRA		| spin on Tx ready
	beq	10$
	movb	#ZERO,TBA

	movb	#0x0a,CRA	| none, disa tx, disa rx
	movb	#0x10,CRA	| reset mr pointer to mr1
	movb	#0x70,ACR	| baud rate set 1, counter via xtal div 16
				| no port ints
	movb	#15,CTUR	| counter value: 3840
	movb	#0,CTLR		| yields: 60Hz interrupts (30Hz on OP3)
	movb	#0x54,OPCR	| op6:txrdya, op4:rxrdya, op3:c/t
	movb	#0xbb,CSRA	| rx & tx at 9600 baud
	movb	#0x13,MR1A	| no rx rts, rxrdy irq, char er, none, even, 8
| next line makes a mess on the screen.
|	movb	#0x0f,MR2A	| normal, no tx rts, no tx cts, 2 stop

	movb	#0x02,IMR	| rx rdy a
	movb	#MYVEC,IVR	| force default int vec
	movb	#0x05,CRA	| none, ena tx, ena rx

	tstb	TSTART		| start timer

	movb	RBA,d0		| clear buffer

20$:	stop	#0x2000		| drop your pants
	tstw	TABLE
	bne	20$
	rts

| ****************************************************************
star:	movw	#0x2700,sr
	movb	#STAR,TBA
	movw	#0x2000,sr
	rte

| ****************************************************************
isr:	movw	#0x2700,sr
	movb	RBA,d0
	movb	d0,TBA
	cmpb	#0x4,d0
	bne	10$
	clrw	TABLE
10$:	movw	#0x2000,sr
	rte
