/*
 *	MC68010 Tiny Monitor -- standalone i/o (MC68681 DUART)
 *	Copyright (C) 1988 Philip L. Budne
 *
 *	May be freely distributed and used for non-profit use only,
 *	provided this, and all other Copyright notices remain intact.
 *
 *	Commercial use is strictly forbidden without explicit, written
 *	permission of the author.
 */

#include "sa_io.h"

#ifdef __STDC__				/* using GCC? */
#define VOLATILE volatile
#else
#define VOLATILE
#endif

# define DU_REG(x) du_bytes[2*(x)]
# include "duart.h"
struct	csr {				/* device csr layout */
    unsigned char du_bytes[32];
};

#define	DUART	0xfc0001		/* DUART address */
#define	RXREADY 01
#define TXREADY 04

rawgetc() {
    VOLATILE register struct csr *cp;

    cp = (struct csr *) DUART;
    while( (cp->DU_SRA & RXREADY) == 0 )
	;
    return( cp->DU_RBA & 0xff );
}

testchar() {
    VOLATILE register struct csr *cp;

    cp = (struct csr *) DUART;
    if( (cp->DU_SRA & RXREADY) == 0 )
	return( 0 );
    return( 1 );
}

putchar( c )
    register char c;
{
    VOLATILE register struct csr *csrptr;
    register int i;

    if ( c == '\0' )
	return;
    if ( c == '\n' )
	sa_putchar('\r');

/*    for (i=0; i<1000 ; i++) ;		/* try not to overrun host */

    csrptr = (struct csr *)DUART;
    while ( (csrptr->DU_SRA & TXREADY) == 0 ) ;	/* poll for idle */
    csrptr->DU_TBA = c;				/* send out on A */
    while ( (csrptr->DU_SRA & TXREADY) == 0 ) ;	/* poll for idle (again?) */
}

getchar() {
    register c = rawgetc() & 0177;
    putchar( c );
    if( c == '\r' )
	putchar( '\n' );
    return( c );
}

#ifdef NOTYET
reset_duart() {
    VOLATILE register struct csr *cp;

    cp = (struct csr *) DUART;
    cp->DU_CRA  = 0x10;			/* reset mr pointer to mr1 */
    cp->DU_ACR  = 0x00;			/* baud set 1, ext ctr, no itnts */
    cp->DU_CSRA = 0xbb;			/* rx, tx at 9600 baud */
    cp->DU_MR1A = 0x13;			/* no rx rts, no rx irq */
					/* char er, none, even, 8 */
    cp->DU_MR2A = 0x0f;			/* normal, no tx rts */
					/* no tx cts, 2 stop */
    cp->DU_CRA  = 0x05;			/* none, ena tx, ena rx */
}
#endif

