/*
 *	MC68010 Tiny Monitor -- dump command
 *	Copyright (C) 1988 Philip L. Budne
 *
 *	May be freely distributed and used for non-profit use only,
 *	provided this, and all other Copyright notices remain intact.
 *
 *	Commercial use is strictly forbidden without explicit, written
 *	permission of the author.
 */

#include "sa_io.h"

# define XOFF 023

do_dump(last)
long *last;
{
    register int i, c;
    register char *cp, *ep, *sp;
    int a;
    char tc;

    a = getarg( &tc, 0 );
    if( a == -1 ) {
	if( tc != '\r' || *last == -1 ) {
	    putchar('\007');
	    return;
	}
	a = *last;			/* dump <cr> means dump next */
    }
    cp = (char *)a;
    if( tc == '-' || tc == ',' || tc == '/' ) {	/* look like a range? */
	a = getarg( &tc, 1 );		/* get next value */
	if( a == -1 ) {
	    putchar('\007');
	    return;
	}
	ep = (char *)a;
    }
    else if( tc != '\r' ) {
	putchar('\n');
	putchar('\007');
	return;
    }
    else
	ep = cp + 16;			/* default is just one line */

    while( cp < ep ) {
	if( testchar() ) {
	    if( getchar() == XOFF )
		while( getchar() == XOFF ) ; /* ctrl/s */
	    else
		return;
	}
	printf("%06x/ ", cp );
	sp = cp;
	for( i = 0; i < 16; i++ )
	    printf("%02x ", 0xff & *cp++ );

	cp = sp;
	putchar('|');
	for( i = 0; i < 16; i++ ) {
	    c = *cp++ & 0177;
	    if( c >= ' ' && c < 0177 )
		putchar( c );
	    else
		putchar('.');
	}
	putchar('|');
	putchar('\n');
    }
    *last = (long) cp;
}

