/*
 *	MC68010 Tiny Monitor -- MC68681 DUART defs
 *	Copyright (C) 1988 Philip L. Budne
 *
 *	May be freely distributed and used for non-profit use only,
 *	provided this, and all other Copyright notices remain intact.
 *
 *	Commercial use is strictly forbidden without explicit, written
 *	permission of the author.
 */

/****************************************************************
 * duart.h
 *
 * defines for mc68681 dual asynch recvr/transmitter
 *
 * source motorola ADI-988, October 1983 (advance information)
 */

/****************************************************************
 * register offsets (page 4-1)
 */
# define DU_MR1A	DU_REG(00)	/* RW mode register a part 1 */
# define DU_MR2A	DU_REG(00)	/* RW mode register a part 2 */

# define DU_SRA		DU_REG(01)	/* RO status register a */
# define DU_CSRA	DU_REG(01)	/* WO clock status register a */

# define DU_TESTA	DU_REG(02)	/* NEVER READ REGISTER 2!! */
# define DU_CRA		DU_REG(02)	/* WO command register a */

# define DU_RBA		DU_REG(03)	/* RO reciever buffer a */
# define DU_TBA		DU_REG(03)	/* WO transmit buffer a */
/*
 */
# define DU_IPCR	DU_REG(04)	/* RO input port change register */
# define DU_ACR		DU_REG(04)	/* WO auxilary control register */

# define DU_ISR		DU_REG(05)	/* RO interrupt state register */
# define DU_IMR		DU_REG(05)	/* WO interrupt mask register */

# define DU_CMSB	DU_REG(06)	/* RO counter most sig bits */
# define DU_CLSB	DU_REG(07)	/* RO counter least sig bits */

# define DU_CTUR	DU_REG(06)	/* WO counter/timer upper register */
# define DU_CTLR	DU_REG(07)	/* WO counter/timer upper register */
/*
 */
# define DU_MR1B	DU_REG(08)	/* RW mode register b part 1 */
# define DU_MR2B	DU_REG(08)	/* RW mode register b part 2 */

# define DU_SRB		DU_REG(09)	/* RO status register b */
# define DU_CSRB	DU_REG(09)	/* WO clock status register b */

# define DU_TESTB	DU_REG(10)	/* NEVER READ REGISTER 10!! */
# define DU_CRB		DU_REG(10)	/* WO command register b */

# define DU_RBB		DU_REG(11)	/* RO reciever buffer b */
# define DU_TBB		DU_REG(11)	/* WO transmit buffer b */
/*
 */
# define DU_IVR		DU_REG(12)	/* RW interrupt vector register */

# define DU_IP		DU_REG(13)	/* RO input port (unlatched) */
# define DU_OPCR	DU_REG(13)	/* WO output port config register */

# define DU_STARTC	DU_REG(14)	/* RA start counter (address triger) */
# define DU_STOPC	DU_REG(15)	/* RA stop counter (address triger) */

# define DU_OPRS	DU_REG(14)	/* WO WA? output port set */
# define DU_OPRC	DU_REG(15)	/* WO WA? output port clear */
