/*
 *	MC68010 Tiny Monitor -- bcopy template (hand optimized)
 *	Copyright (C) 1988 Philip L. Budne
 *
 *	May be freely distributed and used for non-profit use only,
 *	provided this, and all other Copyright notices remain intact.
 *
 *	Commercial use is strictly forbidden without explicit, written
 *	permission of the author.
 */

static bcopy( from, to, len )
    register char *from, *to;
    register short len;
{

    if( len == 0 )
	return;
    if( len > 4 ) {
	if( ((int)from) & 1 ) {		/* source addr odd? */
	    *to++ = *from++;		/* copy one char */
	    len--;			/* account for it */
	}
	if( !(((int)to) & 1) ) {	/* is dest odd? */
	    register long *lf, *lt;	/* no.  copy longs */
	    short l;
	    l = len >> 2;
	    lf = (long *)from;
	    lt = (long *)to;
	    while( l-- > 0 )
		*lt++ = *lf++;

	    len &= 3;			/* get remainder to copy */
	    from = (char *)lf;
	    to = (char *)lt;
	}
    }
    while( len-- > 0 )
	*to++ = *from++;
}
