/* Definitions of target machine for GNU compiler.  ICM 3216 version.
   Copyright (C) 1987 Free Software Foundation, Inc.
   Contributed by Michael Tiemann (tiemann@mcc.com)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

#include "tm-ns32k.h"

#define GAS_SYNTAX

#ifdef SB_REGISTER_TRASHED
#undef INDIRECTABLE_2_ADDRESS_P
#define INDIRECTABLE_2_ADDRESS_P(X)  \
  (GET_CODE (X) == MEM							\
   && (((xfoo0 = XEXP (X, 0), MEM_REG (xfoo0))				\
       || (GET_CODE (xfoo0) == PLUS					\
	   && GET_CODE (XEXP (xfoo0, 0)) == REG				\
	   && MEM_REG (XEXP (xfoo0, 0))					\
	   && CONSTANT_ADDRESS_NO_LABEL_P (XEXP (xfoo0, 1))))))
#endif

/* ABSOLUTE PREFIX, IMMEDIATE_PREFIX and EXTERNAL_PREFIX can be defined
 * to cover most NS32k addressing syntax variations.
 */
#ifndef ABSOLUTE_PREFIX
#define ABSOLUTE_PREFIX '@'
#endif

/* Print subsidiary information on the compiler version in use.  */
#undef TARGET_VERSION
#define TARGET_VERSION printf (" (32000, NS syntax modes, gas directives)");
#define TARGET_DEFAULT 1
#define DBX_DEBUGGING_INFO
/* DBX_REGISTER_NUMBER is also used by sdbout. We have to get the numbers
   the same as is used by SDB/GDB for the same register numbers. It is not
   easy to work out what SDB expects because CC only respects "register"
   for non floating declarations. The following confirms with the current
   GDB organisation for this machine.
 */
#undef DBX_REGISTER_NUMBER
#define DBX_REGISTER_NUMBER(REGNO) ((REGNO) < 8 ? (REGNO):\
 ((REGNO) < 16 ?\
 (REGNO) + 5: ((REGNO) == 16 ? 10: 9)))

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.

   This works with some trickery in the function epilogue or can be left
   undefined if you don't need builtin alloca.
 */

#define EXIT_IGNORE_STACK 1

#undef CALL_USED_REGISTERS
/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
/* This conforms with pcc practice on this machine. Better performance might
   be achieved by making some (fp4 - fp7 ?) be saved in functions but this
   would be incompatible. */
#define CALL_USED_REGISTERS {1, 1, 1, 1, 0, 0, 0, 0, \
			     1, 1, 1, 1, 1, 1, 1, 1, \
			     1, 1}

#if EXIT_IGNORE_STACK == 1
/*
 * EPILOGUE_SCRATCH is a register which is to be used as a scratchpad register
 * in the function epilogue code.
 * EPILOGUE_SCRATCH can be any register not needed to return arguments. If it
 * is not one of CALL_USED_REGISTERS, FUNCTION_PROLOGUE and FUNCTION_EPILOGUE
 * will ensure that the EPILOGUE_SCRATCH register is saved and restored.
 */
#define EPILOGUE_SCRATCH 3	/* Should be safe */
#endif

#undef MEM_REG
#define MEM_REG(X)							\
  ( (GET_CODE (X) == REG)						\
  && ( (REGNO (X) == FRAME_POINTER_REGNUM)				\
    || (REGNO (X) == STACK_POINTER_REGNUM) ) )

#if defined(IMMEDIATE_PREFIX) && IMMEDIATE_PREFIX
#define PUT_IMMEDIATE_PREFIX(FILE) putc(IMMEDIATE_PREFIX, FILE)
#else
#define PUT_IMMEDIATE_PREFIX(FILE)
#endif
#if defined(ABSOLUTE_PREFIX) && ABSOLUTE_PREFIX
#define PUT_ABSOLUTE_PREFIX(FILE) putc(ABSOLUTE_PREFIX, FILE)
#else
#define PUT_ABSOLUTE_PREFIX(FILE)
#endif
#if defined(EXTERNAL_PREFIX) && EXTERNAL_PREFIX
#define PUT_EXTERNAL_PREFIX(FILE) putc(EXTERNAL_PREFIX, FILE)
#else
#define PUT_EXTERNAL_PREFIX(FILE)
#endif

#undef PRINT_OPERAND
#define PRINT_OPERAND(FILE, X, CODE)  					\
{									\
  if (CODE == '$')							\
    PUT_IMMEDIATE_PREFIX (FILE);					\
  else if (CODE == '?')							\
    PUT_EXTERNAL_PREFIX(FILE);						\
  else if (GET_CODE (X) == REG)						\
    fprintf (FILE, "%s", reg_names[REGNO (X)]);				\
  else if (GET_CODE (X) == MEM)						\
    output_address (XEXP (X, 0));					\
  else if (GET_CODE (X) == CONST_DOUBLE && GET_MODE (X) != DImode)	\
    if (GET_MODE (X) == DFmode)						\
      {									\
	union { double d; int i[2]; } u;				\
	u.i[0] = CONST_DOUBLE_LOW (X); u.i[1] = CONST_DOUBLE_HIGH (X);	\
	PUT_IMMEDIATE_PREFIX(FILE);					\
	fprintf (FILE, "0d%.20e", u.d);					\
      }									\
    else								\
      {									\
	union { double d; int i[2]; } u;				\
	u.i[0] = CONST_DOUBLE_LOW (X); u.i[1] = CONST_DOUBLE_HIGH (X);	\
	PUT_IMMEDIATE_PREFIX(FILE);					\
	fprintf (FILE, "0f%.20e", u.d);					\
      }									\
  else									\
    {									\
      PUT_IMMEDIATE_PREFIX(FILE);					\
      output_addr_const (FILE, X);					\
    }									\
}

#undef PRINT_OPERAND_ADDRESS
#define PRINT_OPERAND_ADDRESS(FILE, ADDR)  print_operand_address(FILE, ADDR)

#ifndef __GNUC__
/* The standard C compiler cannot handle expressions of the size generated by
   expanding GO_IF_LEGITIMATE_ADDRESS so we make some bits into function calls
 */
#undef INDIRECTABLE_1_ADDRESS_P
#ifdef REG_OK_STRICT
#define INDIRECTABLE_1_ADDRESS_P(X) (indirectable_1_address_p_strict(X))
#else
#define INDIRECTABLE_1_ADDRESS_P(X) (indirectable_1_address_p(X))
#endif
#endif /* ! __GNUC__ */

#define TARGET_MEM_FUNCTIONS

/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */

#undef FUNCTION_PROLOGUE
#ifdef EPILOGUE_SCRATCH
/*
 * The function prologue for the ns32k is fairly simple.
 * If a frame pointer is needed (decided in reload.c ?) then
 * we need assembler of the form
 *
 *  # Save the oldframe pointer, set the new frame pointer, make space
 *  # on the stack and save any general purpose registers necessary
 *
 *  enter [<general purpose regs to save>], <local stack space>
 *
 *  movf  fn, tos    # Save any floating point registers necessary
 *  .
 *  .
 *
 * If a frame pointer is not needed we need assembler of the form
 *  # Save any general purpose registers necessary
 *
 *  save [<general purpose regs to save>]
 *
 *  movf  fn, tos    # Save any floating point registers necessary
 *  .
 *  .
 *
 * The only complication is we must ensure that the EPILOGUE_SCRATCH
 * register is treated as though it has always been used.
 */

#define FUNCTION_PROLOGUE(FILE, SIZE)     \
{ register int regno, g_regs_used = 0;				\
  int used_regs_buf[8], *bufp = used_regs_buf;			\
  int used_fregs_buf[8], *fbufp = used_fregs_buf;		\
  extern char call_used_regs[];					\
  MAIN_FUNCTION_PROLOGUE;					\
  for (regno = 0; regno < 8; regno++)				\
    if ((regs_ever_live[regno]					\
         || ((regno == EPILOGUE_SCRATCH) && frame_pointer_needed))\
	&& ! call_used_regs[regno])				\
    {								\
      *bufp++ = regno; g_regs_used++;				\
    }								\
  *bufp = -1;							\
  for (; regno < 16; regno++)					\
    if (regs_ever_live[regno] && !call_used_regs[regno]) {	\
      *fbufp++ = regno;						\
    }								\
  *fbufp = -1;							\
  bufp = used_regs_buf;						\
  if (frame_pointer_needed)					\
    fprintf (FILE, "\tenter [");				\
  else if (g_regs_used)						\
    fprintf (FILE, "\tsave [");					\
  while (*bufp >= 0)						\
    {								\
      fprintf (FILE, "r%d", *bufp++);				\
      if (*bufp >= 0)						\
	fputc (',', FILE);					\
    }								\
  if (frame_pointer_needed)					\
    fprintf (FILE, "],%d\n", SIZE);				\
  else if (g_regs_used)						\
    fprintf (FILE, "]\n");					\
  fbufp = used_fregs_buf;					\
  while (*fbufp >= 0)						\
    {								\
      if ((*fbufp & 1) || (fbufp[0] != fbufp[1] - 1))		\
	fprintf (FILE, "\tmovf f%d,tos\n", *fbufp++ - 8);	\
      else							\
	{							\
	  fprintf (FILE, "\tmovl f%d,tos\n", fbufp[0] - 8);	\
	  fbufp += 2;						\
	}							\
    }								\
}
#else
#define FUNCTION_PROLOGUE(FILE, SIZE)     \
{ register int regno, g_regs_used = 0;				\
  int used_regs_buf[8], *bufp = used_regs_buf;			\
  int used_fregs_buf[8], *fbufp = used_fregs_buf;		\
  extern char call_used_regs[];					\
  MAIN_FUNCTION_PROLOGUE;					\
  for (regno = 0; regno < 8; regno++)				\
    if (regs_ever_live[regno] && !call_used_regs[regno]) {	\
      *bufp++ = regno; g_regs_used++;				\
    }								\
  *bufp = -1;							\
  for (; regno < 16; regno++)					\
    if (regs_ever_live[regno] && !call_used_regs[regno]) {	\
      *fbufp++ = regno;						\
    }								\
  *fbufp = -1;							\
  bufp = used_regs_buf;						\
  if (frame_pointer_needed)					\
    fprintf (FILE, "\tenter [");				\
  else if (g_regs_used)						\
    fprintf (FILE, "\tsave [");					\
  while (*bufp >= 0)						\
    {								\
      fprintf (FILE, "r%d", *bufp++);				\
      if (*bufp >= 0)						\
	fputc (',', FILE);					\
    }								\
  if (frame_pointer_needed)					\
    fprintf (FILE, "],%d\n", SIZE);				\
  else if (g_regs_used)						\
    fprintf (FILE, "]\n");					\
  fbufp = used_fregs_buf;					\
  while (*fbufp >= 0)						\
    {								\
      if ((*fbufp & 1) || (fbufp[0] != fbufp[1] - 1))		\
	fprintf (FILE, "\tmovf f%d,tos\n", *fbufp++ - 8);	\
      else							\
	{							\
	  fprintf (FILE, "\tmovl f%d,tos\n", fbufp[0] - 8);	\
	  fbufp += 2;						\
	}							\
    }								\
}
#endif /* EPILOGUE_SCRATCH */

/* This macro generates the assembly code for function exit,
   on machines that need it.  If FUNCTION_EPILOGUE is not defined
   then individual return instructions are generated for each
   return statement.  Args are same as for FUNCTION_PROLOGUE.
 */
#undef FUNCTION_EPILOGUE


#ifdef EPILOGUE_SCRATCH
/*
 * The function epilogue should not depend on the current stack pointer!
 * It should use the frame pointer only.  This is mandatory because
 * of alloca; we also take advantage of it to omit stack adjustments
 * before returning.
 *
 * This is difficult to conform with on the ns32k because of the order
 * in which the 32k "enter" instruction does things. It sets
 * the frame pointer to the current stack pointer, before it saves the
 * general purpose registers. That means that if any stack didling has gone
 * on (alloca) we need need to restore the stack pointer before we pop the
 * general purpose registers. If the stack has been changed then
 * frame_pointer_needed must be true.
 * If a frame pointer is needed (decided in reload.c ?) then
 * we need assembler of the form
 *
 *  # The EPILOGUE_SCRATCH register is register 3.
 *  addr offset(fp), r3	# Offset = -((no of saved registers) * 4 + space)
 *  lprd sp, r3		# sp now points at saved registers.
 *  movf  tos, fn	# Restore any saved floating point registers
 *  .
 *  .
 *
 *  # Restore any saved general purpose registers, restore the stack
 *  # pointer from the frame pointer, restore the old frame pointer.
 *  exit [<general purpose regs to save>]
 *
 * If a frame pointer is not needed we need assembler of the form
 *  # Restore any general purpose registers saved
 *
 *  movf  tos, fn	# Restore any saved floating point registers
 *  .
 *  .
 *  .
 *  restore [<general purpose regs to save>]
 *
 * We must also ensure that the EPILOGUE_SCRATCH
 * register is treated as though it has always been used.
 */
#define FUNCTION_EPILOGUE(FILE, SIZE) \
{ extern int current_function_pops_args;			\
  extern int current_function_args_size;			\
  register int regno, g_regs_used = 0, f_regs_used = 0;		\
  int used_regs_buf[8], *bufp = used_regs_buf;			\
  int used_fregs_buf[8], *fbufp = used_fregs_buf;		\
  extern char call_used_regs[];					\
  *fbufp++ = -2;						\
  for (regno = 8; regno < 16; regno++)				\
    if (regs_ever_live[regno] && !call_used_regs[regno]) {	\
       *fbufp++ = regno; f_regs_used++;				\
    }								\
  fbufp--;							\
  for (regno = 0; regno < 8; regno++)				\
    if ((regs_ever_live[regno]					\
         || ((regno == EPILOGUE_SCRATCH) && frame_pointer_needed))\
	&& ! call_used_regs[regno])				\
    {                                                         	\
      *bufp++ = regno; g_regs_used++;				\
    }                                                         	\
  if (frame_pointer_needed)					\
    {								\
      fprintf (FILE, "\taddr %d(fp),r%d\n\tlprd sp,r%d\n",	\
               -(SIZE + (f_regs_used + g_regs_used) * 4),	\
	       EPILOGUE_SCRATCH, EPILOGUE_SCRATCH);		\
    }								\
  while (fbufp > used_fregs_buf)				\
    {								\
      if ((*fbufp & 1) && fbufp[0] == fbufp[-1] + 1)		\
	{							\
	  fprintf (FILE, "\tmovl tos,f%d\n", fbufp[-1] - 8);	\
	  fbufp -= 2;						\
	}							\
      else fprintf (FILE, "\tmovf tos,f%d\n", *fbufp-- - 8);	\
    }								\
  if (frame_pointer_needed)					\
      fprintf (FILE, "\texit [");				\
  else if (g_regs_used)						\
    fprintf (FILE, "\trestore [");				\
  while (bufp > used_regs_buf)					\
    {								\
      fprintf (FILE, "r%d", *--bufp);				\
      if (bufp > used_regs_buf)					\
	fputc (',', FILE);					\
    }								\
  if (g_regs_used || frame_pointer_needed)			\
    fprintf (FILE, "]\n");					\
								\
  if (current_function_pops_args && current_function_args_size)	\
    fprintf (FILE, "\tret %d\n", current_function_args_size);	\
  else fprintf (FILE, "\tret 0\n"); }
#else
#define FUNCTION_EPILOGUE(FILE, SIZE) \
{ extern int current_function_pops_args;			\
  extern int current_function_args_size;			\
  register int regno, g_regs_used = 0;				\
  int used_regs_buf[8], *bufp = used_regs_buf;			\
  int used_fregs_buf[8], *fbufp = used_fregs_buf;		\
  extern char call_used_regs[];					\
  *fbufp++ = -2;						\
  for (regno = 8; regno < 16; regno++)				\
    if (regs_ever_live[regno] && !call_used_regs[regno]) {	\
       *fbufp++ = regno;					\
    }								\
  fbufp--;							\
  for (regno = 0; regno < 8; regno++)				\
    if (regs_ever_live[regno] && ! call_used_regs[regno])	\
      {                                                         \
        *bufp++ = regno; g_regs_used++;				\
      }                                                         \
  while (fbufp > used_fregs_buf)				\
    {								\
      if ((*fbufp & 1) && fbufp[0] == fbufp[-1] + 1)		\
	{							\
	  fprintf (FILE, "\tmovl tos,f%d\n", fbufp[-1] - 8);	\
	  fbufp -= 2;						\
	}							\
      else fprintf (FILE, "\tmovf tos,f%d\n", *fbufp-- - 8);	\
    }								\
  if (frame_pointer_needed)					\
      fprintf (FILE, "\texit [");				\
  else if (g_regs_used)						\
    fprintf (FILE, "\trestore [");				\
  while (bufp > used_regs_buf)					\
    {								\
      fprintf (FILE, "r%d", *--bufp);				\
      if (bufp > used_regs_buf)					\
	fputc (',', FILE);					\
    }								\
  if (frame_pointer_needed)					\
    fprintf (FILE, "],%d\n", SIZE);				\
  else if (g_regs_used)						\
    fprintf (FILE, "]\n");					\
								\
  if (current_function_pops_args && current_function_args_size)	\
    fprintf (FILE, "\tret %d\n", current_function_args_size);	\
  else fprintf (FILE, "\tret 0\n"); }
#endif

/* If the memory address ADDR is relative to the frame pointer,
   correct it to be relative to the stack pointer instead.
   This is for when we don't use a frame pointer.
   ADDR should be a variable name.  */

#undef FIX_FRAME_POINTER_ADDRESS
#define FIX_FRAME_POINTER_ADDRESS(ADDR,DEPTH) \
{							               \
  register int regno, offset = (DEPTH) - 4;		               \
  extern char call_used_regs[];				               \
  extern rtx fix_frame_pointer_address();			       \
  for (regno = 0; regno < 16; regno++)			               \
    if (regs_ever_live[regno] && ! call_used_regs[regno])	       \
      offset += 4;					               \
  ADDR = fix_frame_pointer_address(ADDR, offset);	               \
}


