/* Definitions of target machine for GNU compiler.  WBC version,
   derived from SEQUENT NS32000 version.
   Copyright (C) 1987 Free Software Foundation, Inc.
   Contributed by Michael Tiemann (tiemann@mcc.com)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Two flags to control how addresses are printed in assembler insns.  */
/* #define SEQUENT_ADDRESS_BUG 1	WBC */
#define SEQUENT_ADDRESS_BUG 0
/* #define SEQUENT_BASE_REGS		WBC */

# define HOST_68K /* budd */

#if 0
#define USG				/*WBC*/
#define bcopy(a,b,c) memcpy (b,a,c)	/*WBC*/
#define bzero(a,b) memset (a,0,b)	/*WBC*/
#define bcmp(a,b,c) memcmp (a,b,c)	/*WBC*/
#endif

#define WBC

#include "config/tm-ns32k.h"		/*WBC 1.35*/

/* start WBC */

/* Experiment to pack struct's tighter.  It's 32 in tm-ns32k.h. 
 * Seems to do the job.  See test/struct_size.c.  12 June 1989 */
#undef	BIGGEST_ALIGNMENT
#define BIGGEST_ALIGNMENT	16

#undef  ASM_FILE_START
#define ASM_FILE_START(FILE) ;

#undef  ASM_APP_ON
#define ASM_APP_ON ""

#undef  ASM_APP_OFF
#define ASM_APP_OFF ""

#undef  ASM_OUTPUT_SKIP
#define ASM_OUTPUT_SKIP(FILE,SIZE)  			\
  fprintf (FILE, "\t.blkb %d\n", (SIZE))

#undef  ASM_OUTPUT_COMMON
#undef  ASM_OUTPUT_LOCAL
/* GCC now seems to change back to old segment, no need to do it after
 * doing .bss stuff.
 *
 *#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)	\
 *  (fputs ("\t.bss\n", (FILE)),                          \
 *  fputs (((SIZE) > 1)?"\t.align 2\n":"", (FILE)),       \
 *  assemble_name ((FILE), (NAME)),                       \
 *  fprintf ((FILE), "::\n\t.blkb %d\n", (ROUNDED)),	\
 *  fprintf ((FILE), "\t%s\n",				\
 *	in_section == in_data? ".data": ".text"))
 *
 *#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)	\
 *  (fputs ("\t.bss\n", (FILE)),                          \
 *  fputs (((SIZE) > 1)?"\t.align 2\n":"", (FILE)),       \
 *  assemble_name ((FILE), (NAME)),                       \
 *  fprintf ((FILE), ":\n\t.blkb %d\n", (ROUNDED)),	\
 *  fprintf ((FILE), "\t%s\n",				\
 *	in_section == in_data? ".data": ".text"))
 */
#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)	\
  (fputs (".bss\n", (FILE)),				\
  fputs (((SIZE) > 1)?"\t.align 2\n":"", (FILE)),       \
  assemble_name ((FILE), (NAME)),                       \
  fprintf ((FILE), "::\n\t.blkb %d\n", (ROUNDED)))

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)	\
  (fputs (".bss\n", (FILE)),				\
  fputs (((SIZE) > 1)?"\t.align 2\n":"", (FILE)),       \
  assemble_name ((FILE), (NAME)),                       \
  fprintf ((FILE), ":\n\t.blkb %d\n", (ROUNDED)))

#undef ASM_OUTPUT_BYTE
#define ASM_OUTPUT_BYTE(FILE,VALUE)  			\
  fprintf (FILE, "\t.byte h'%x\n", (VALUE))
/* end WBC */

/* This is BSD, so it wants DBX format.  */
/* #define DBX_DEBUGGING_INFO		WBC */

/* Sequent has some changes in the format of DBX symbols.  */
/* #define DBX_NO_XREFS 1		WBC */

/* Don't split DBX symbols into continuations.  */
/* #define DBX_CONTIN_LENGTH 0		WBC */

#define TARGET_DEFAULT 1

/* Print subsidiary information on the compiler version in use.  */
#undef TARGET_VERSION
#define TARGET_VERSION fprintf (stderr, " (32000, WBC syntax)");

#undef CPP_PREDEFINES
/* #define CPP_PREDEFINES "-Dns32000 -Dsequent -Dunix"	WBC */
#define CPP_PREDEFINES "-Dns32000 -Dunix"

/* WBC changed, added shift since parm is LOG */
#undef ASM_OUTPUT_ALIGN
#define ASM_OUTPUT_ALIGN(FILE,LOG)		\
  fprintf (FILE, "\t.align %d\n", 1<<(LOG))

/* This is how to align the code that follows an unconditional branch.  */

#undef ASM_OUTPUT_ALIGN_CODE
#define ASM_OUTPUT_ALIGN_CODE(FILE)		/*WBC*/	\
/*  fprintf (FILE, "\t.align 2\n")  bad for debugging */

/* %$ means print the prefix for an immediate operand.
   On the sequent, no prefix is used for such.  */

#undef PRINT_OPERAND
#define PRINT_OPERAND(FILE, X, CODE)  \
{ if (CODE == '$') ;							\
  else if (CODE == '?');						\
  else if (CODE == 'r') 	/* WBC for bsr */			\
	output_addr_const (FILE, XEXP(x,0));				\
  else if (GET_CODE (X) == REG)						\
    fprintf (FILE, "%s", reg_names [REGNO (X)]);			\
  else if (GET_CODE (X) == MEM)						\
	output_address (XEXP (X, 0));	/*WBC*/				\
  else if (GET_CODE (X) == CONST_DOUBLE && GET_MODE (X) != DImode)	\
    if (GET_MODE (X) == DFmode)						\
      { union { double d; int i[2]; } u;                                \
        u.i[0] = CONST_DOUBLE_LOW (X); u.i[1] = CONST_DOUBLE_HIGH (X);  \
        fprintf (FILE, "f'%.20e", u.d); }				\
    else								\
      { union { double d; int i[2]; } u;                                \
        u.i[0] = CONST_DOUBLE_LOW (X); u.i[1] = CONST_DOUBLE_HIGH (X);  \
        fprintf (FILE, "f'%.20e", u.d); }				\
  else output_addr_const (FILE, X); }

#undef PRINT_OPERAND_ADDRESS
#define PRINT_OPERAND_ADDRESS(FILE, ADDR)  print_operand_address(FILE, ADDR)

/*** change .long (means 64-bit float in my assembler) to .double
 */
#undef ASM_OUTPUT_INT
#define ASM_OUTPUT_INT(FILE,VALUE)  \
( fprintf (FILE, "\t.double "),                   \
  output_addr_const (FILE, (VALUE)),            \
  fprintf (FILE, "\n"))

#undef ASM_OUTPUT_ADDR_VEC_ELT
#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE)  \
  fprintf (FILE, "\t.double L%d\n", VALUE)	/* what's the L do??? */

/*** Floating Point ***
 *   1) change .double to .long
 *   2) change float and double constants to "f'123.456"
 */

/* This is how to output an assembler line defining a `double' constant.  */

#undef ASM_OUTPUT_DOUBLE
#define ASM_OUTPUT_DOUBLE(FILE,VALUE)  \
  fprintf (FILE, "\t.long f'%.20e\n", (VALUE))

/* This is how to output an assembler line defining a `float' constant.  */

#undef ASM_OUTPUT_FLOAT
#define ASM_OUTPUT_FLOAT(FILE,VALUE)  \
  fprintf (FILE, "\t.float f'%.20e\n", (VALUE))
