package org.jboss.cache.transaction;

import org.jboss.cache.Cache;
import org.jboss.cache.config.Configuration;

import javax.transaction.TransactionManager;

/**
 * Factory interface, allows {@link Cache} to use different transactional systems.
 * Names of implementors of this class can be configured using
 * {@link Configuration#setTransactionManagerLookupClass}.
 *
 * @author Bela Ban, Aug 26 2003
 * @version $Id: TransactionManagerLookup.java 3892 2007-05-23 10:28:59Z msurtani $
 */
public interface TransactionManagerLookup
{

   /**
    * Returns a new TransactionManager.
    *
    * @throws Exception if lookup failed
    */
   TransactionManager getTransactionManager() throws Exception;

}
