
/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ROOM_HPP)
#include <Room.hpp>
#endif

const RoomNumber  netherNumber(0);

using namespace corelinux;
#include <iostream>
using namespace std;

//
// Default Constructor
//

Room::Room( void )
   :
   theRoomNumber( netherNumber )
{
   theSides[0] = theSides[1] = theSides[2] = theSides[3] = NULLPTR;
}

//
// Constructor with a room number
//

Room::Room( RoomNumberCref aNumber )
   :
   theRoomNumber( aNumber )
{
   theSides[0] = theSides[1] = theSides[2] = theSides[3] = NULLPTR;
   ENSURE( theRoomNumber != netherNumber );
}

//
// Copy constructor
//

Room::Room( RoomCref ) throw( CORELINUX(Assertion) )
   :
   theRoomNumber( netherNumber )
{
   theSides[0] = theSides[1] = theSides[2] = theSides[3] = NULLPTR;
   NEVER_GET_HERE;
}

//
// Virtual destructor
//

Room::~Room( void )
{
   theSides[0] = theSides[1] = theSides[2] = theSides[3] = NULLPTR;
   theRoomNumber = netherNumber ;
}

//
// Assignment operator
//

RoomRef  Room::operator=( RoomCref ) throw( CORELINUX( Assertion ) )
{
   NEVER_GET_HERE;
   return (*this);
}

//
// Equality operator
//

bool  Room::operator==( RoomCref aRef ) const
{
   return (theRoomNumber == aRef.getRoomNumber() );
}

//
// Retrieve the room number
//

RoomNumberCref Room::getRoomNumber( void ) const
{
   return theRoomNumber;
}

//
// Get what is on the specific side
//

MapSitePtr  Room::getSide( Direction aDirection ) const
{
   return theSides[aDirection];
}

//
// Set the room number
//

void  Room::setRoomNumber( RoomNumberCref aRef )
{
   REQUIRE( theRoomNumber == netherNumber );
   theRoomNumber = aRef;
}

//
// Sets a object for the given direction side
//

void  Room::setSide( Direction aDirection, MapSitePtr aMapSite )
{
   theSides[aDirection] = aMapSite;
}

//
// Don't quite what to do with this
//

void  Room::enter( void )
{
   cout  << "You have entered Room " << theRoomNumber << endl;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/07/28 01:51:37 $
   $Locker:  $
*/


