/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.pack200.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.harmony.pack200.ClassBands;
import org.apache.harmony.pack200.Codec;
import org.apache.harmony.pack200.Pack200Exception;
import org.apache.harmony.pack200.Segment;
import org.apache.harmony.pack200.tests.AbstractBandsTestCase;
import org.apache.harmony.pack200.tests.ClassBandsTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClassBandsTest
extends AbstractBandsTestCase {
    private String[] cpClasses;
    private String[] cpDescriptor;
    ClassBands classBands = new ClassBands((Segment)new MockSegment(this));

    public void testSimple() throws IOException, Pack200Exception {
        this.cpClasses = new String[]{"Class1", "Class2", "Class3", "Interface1", "Interface2"};
        byte[] classThis = Codec.DELTA5.encode(1L, 0L);
        byte[] classSuper = Codec.DELTA5.encode(2L, 0L);
        byte[] classInterfaceCount = Codec.DELTA5.encode(2L, 0L);
        byte[] classInterfaceRef1 = this.classBands.encodeBandLong(new long[]{3L, 4L}, Codec.DELTA5);
        byte[] classFieldCount = Codec.DELTA5.encode(0L, 0L);
        byte[] classMethodCount = Codec.DELTA5.encode(0L, 0L);
        byte[] classFlags = Codec.UNSIGNED5.encode(0L, 0L);
        byte[][] allArrays = new byte[][]{classThis, classSuper, classInterfaceCount, classInterfaceRef1, classFieldCount, classMethodCount, classFlags};
        int total = classThis.length + classSuper.length + classInterfaceCount.length + classInterfaceRef1.length + classFieldCount.length + classMethodCount.length + classFlags.length;
        byte[] bytes = new byte[total];
        int index = 0;
        int i = 0;
        while (i < allArrays.length) {
            int j = 0;
            while (j < allArrays[i].length) {
                bytes[index] = allArrays[i][j];
                ++index;
                ++j;
            }
            ++i;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.classBands.unpack((InputStream)in);
        ClassBandsTest.assertEquals((String)this.cpClasses[1], (String)this.classBands.getClassThis()[0]);
        ClassBandsTest.assertEquals((String)this.cpClasses[2], (String)this.classBands.getClassSuper()[0]);
        ClassBandsTest.assertEquals((int)1, (int)this.classBands.getClassInterfaces().length);
        ClassBandsTest.assertEquals((int)2, (int)this.classBands.getClassInterfaces()[0].length);
        ClassBandsTest.assertEquals((String)this.cpClasses[3], (String)this.classBands.getClassInterfaces()[0][0]);
        ClassBandsTest.assertEquals((String)this.cpClasses[4], (String)this.classBands.getClassInterfaces()[0][1]);
        this.cpClasses = null;
    }

    public void testWithMethods() throws Pack200Exception, IOException {
        this.cpClasses = new String[]{"Class1", "Class2", "Class3"};
        this.cpDescriptor = new String[]{"method1", "method2", "method3"};
        byte[] classThis = Codec.DELTA5.encode(1L, 0L);
        byte[] classSuper = Codec.DELTA5.encode(2L, 0L);
        byte[] classInterfaceCount = Codec.DELTA5.encode(0L, 0L);
        byte[] classFieldCount = Codec.DELTA5.encode(0L, 0L);
        byte[] classMethodCount = Codec.DELTA5.encode(3L, 0L);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        lArray[2] = 2L;
        byte[] methodDescr = this.classBands.encodeBandLong(lArray, Codec.MDELTA5);
        byte[] methodFlagsLo = this.classBands.encodeBandLong(new long[3], Codec.UNSIGNED5);
        byte[] classFlags = Codec.UNSIGNED5.encode(0L, 0L);
        byte[][] allArrays = new byte[][]{classThis, classSuper, classInterfaceCount, classFieldCount, classMethodCount, methodDescr, methodFlagsLo, classFlags};
        int total = 0;
        int i = 0;
        while (i < allArrays.length) {
            total += allArrays[i].length;
            ++i;
        }
        byte[] bytes = new byte[total];
        int index = 0;
        int i2 = 0;
        while (i2 < allArrays.length) {
            int j = 0;
            while (j < allArrays[i2].length) {
                bytes[index] = allArrays[i2][j];
                ++index;
                ++j;
            }
            ++i2;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.classBands.unpack((InputStream)in);
        ClassBandsTest.assertEquals((String)this.cpClasses[1], (String)this.classBands.getClassThis()[0]);
        ClassBandsTest.assertEquals((String)this.cpClasses[2], (String)this.classBands.getClassSuper()[0]);
        ClassBandsTest.assertEquals((int)1, (int)this.classBands.getMethodDescr().length);
        ClassBandsTest.assertEquals((int)3, (int)this.classBands.getMethodDescr()[0].length);
        ClassBandsTest.assertEquals((String)this.cpDescriptor[0], (String)this.classBands.getMethodDescr()[0][0]);
        ClassBandsTest.assertEquals((String)this.cpDescriptor[1], (String)this.classBands.getMethodDescr()[0][1]);
        ClassBandsTest.assertEquals((String)this.cpDescriptor[2], (String)this.classBands.getMethodDescr()[0][2]);
        this.cpClasses = null;
        this.cpDescriptor = null;
    }

    public void testWithFields() {
    }

    static /* synthetic */ String[] access$0(ClassBandsTest classBandsTest) {
        return classBandsTest.cpClasses;
    }

    static /* synthetic */ String[] access$1(ClassBandsTest classBandsTest) {
        return classBandsTest.cpDescriptor;
    }
}

