#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from ovsdbapp.backend.ovs_idl import event


class WaitForPortBindingEvent(event.WaitEvent):
    def __init__(self, port, timeout=5):
        super(WaitForPortBindingEvent, self).__init__(
            (self.ROW_CREATE,), 'Port_Binding', (('logical_port', '=', port),),
            timeout=timeout)


class ExceptionalMatchFnEvent(WaitForPortBindingEvent):
    def __init__(self, port, timeout=1):
        super(ExceptionalMatchFnEvent, self).__init__(port, timeout)

    def match_fn(self, event, row, old):
        raise Exception()


class MatchFnConditionsEvent(event.WaitEvent):
    def __init__(self, *args, timeout=1, **kwargs):
        super().__init__(*args, timeout=timeout, **kwargs)

    def match_fn(self, event, row, old):
        # This should only be called if we pass all other conditions
        # so make sure wait() returns False if we see any other events. This
        # ensures that adding a match_fn() doesn't skip the conditions checks.
        return True
