#! Copyright (c) 2020-2026 Valve Corporation
#! Copyright (c) 2020-2026 LunarG, Inc.
#! 
#! Licensed under the Apache License, Version 2.0 (the "License");
#! you may not use this file except in compliance with the License.
#! You may obtain a copy of the License at
#! 
#!     http://www.apache.org/licenses/LICENSE-2.0
#! 
#! Unless required by applicable law or agreed to in writing, software
#! distributed under the License is distributed on an "AS IS" BASIS,
#! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#! See the License for the specific language governing permissions and
#! limitations under the License.
#! 
#! This code was generated by Vulkan Configurator 3.4.2


#! reference layer
#! ==========================================
#! VK_LAYER_LUNARG_reference_1_2_1 - 1.4.333 (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  The main, comprehensive Khronos validation layer.

#!  Vulkan is an Explicit API, enabling direct control over how GPUs actually
#!  work. By design, minimal error checking is done inside a Vulkan driver.
#!  Applications have full control and responsibility for correct operation. Any
#!  errors in how Vulkan is used can result in a crash.

#! For more information about the layer: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html

#! toogle
#! ------------------------------------------
#! toogle (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  true or false
export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true

#! enum
#! ------------------------------------------
#! enum_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  enum case
export VK_LUNARG_REFERENCE_1_2_1_ENUM_REQUIRED_ONLY=value1

#! enum
#! ------------------------------------------
#! enum_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  enum case
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#enum
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_ENUM_WITH_OPTIONAL=value1

#! flags
#! ------------------------------------------
#! flags_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  flags case
#! This setting can list multiple values using the "," (comma) separator.
export VK_LUNARG_REFERENCE_1_2_1_FLAGS_REQUIRED_ONLY=flag0,flag1

#! flags
#! ------------------------------------------
#! flags_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  flags case
#! This setting can list multiple values using the "," (comma) separator.
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#flags
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_FLAGS_WITH_OPTIONAL=flag0,flag1

#! String
#! ------------------------------------------
#! string_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  string
export VK_LUNARG_REFERENCE_1_2_1_STRING_REQUIRED_ONLY=A string

#! String
#! ------------------------------------------
#! string_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  string
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#string
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_STRING_WITH_OPTIONAL=A string

#! bool
#! ------------------------------------------
#! bool_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  true or false
export VK_LUNARG_REFERENCE_1_2_1_BOOL_REQUIRED_ONLY=true

#! bool
#! ------------------------------------------
#! bool_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  true or false
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#bool
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_BOOL_WITH_OPTIONAL=true

#! Load file
#! ------------------------------------------
#! load_file_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Load file path
export VK_LUNARG_REFERENCE_1_2_1_LOAD_FILE_REQUIRED_ONLY=./test.txt

#! Load file
#! ------------------------------------------
#! load_file_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Load file path
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#load_file
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_LOAD_FILE_WITH_OPTIONAL=./test.json

#! Save file
#! ------------------------------------------
#! save_file_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Save file path
export VK_LUNARG_REFERENCE_1_2_1_SAVE_FILE_REQUIRED_ONLY=./test.json

#! Save file
#! ------------------------------------------
#! save_file_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Save file path
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#save_file
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_SAVE_FILE_WITH_OPTIONAL=./test.json

#! Save folder
#! ------------------------------------------
#! save_folder_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Save folder path
export VK_LUNARG_REFERENCE_1_2_1_SAVE_FOLDER_REQUIRED_ONLY=./test

#! Save folder
#! ------------------------------------------
#! save_folder_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Save folder path
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#save_folder
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_SAVE_FOLDER_WITH_OPTIONAL=./test

#! Integer
#! ------------------------------------------
#! int_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Integer Description
export VK_LUNARG_REFERENCE_1_2_1_INT_REQUIRED_ONLY=76

#! Integer
#! ------------------------------------------
#! int_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Integer Description
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#int
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_INT_WITH_OPTIONAL=76

#! Float
#! ------------------------------------------
#! float_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Float Description
export VK_LUNARG_REFERENCE_1_2_1_FLOAT_REQUIRED_ONLY=76.500000

#! Float
#! ------------------------------------------
#! float_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Float Description
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#float
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_FLOAT_WITH_OPTIONAL=76.500

#! Frames
#! ------------------------------------------
#! frames_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Frames Description
export VK_LUNARG_REFERENCE_1_2_1_FRAMES_REQUIRED_ONLY=76-82,75

#! Frames
#! ------------------------------------------
#! frames_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  Frames Description
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#frames
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_FRAMES_WITH_OPTIONAL=76-82,75

#! List
#! ------------------------------------------
#! list_required_only (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  List description
#! This setting can list multiple values using the "," (comma) separator.
export VK_LUNARG_REFERENCE_1_2_1_LIST_REQUIRED_ONLY=76,82,stringB,stringD

#! List
#! ------------------------------------------
#! list_with_optional (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  List description
#! This setting can list multiple values using the "," (comma) separator.
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#list
#! This setting requires ALL of the following values:
#! - export VK_LUNARG_REFERENCE_1_2_1_TOOGLE=true
export VK_LUNARG_REFERENCE_1_2_1_LIST_WITH_OPTIONAL=76,82,stringB,stringD

#! List
#! ------------------------------------------
#! list_empty (BETA) (WINDOWS_X86, WINDOWS_ARM, LINUX, ANDROID)
#!  List description
#! This setting can list multiple values using the "," (comma) separator.
#! For more information about the feature: https://vulkan.lunarg.com/doc/sdk/latest/windows/layer_dummy.html#list
export VK_LUNARG_REFERENCE_1_2_1_LIST_EMPTY=

