# Ruby Documentation

Welcome to the official Ruby programming language documentation.

## Getting Started

New to Ruby? Start with our [Getting Started Guide](https://www.ruby-lang.org/en/documentation/quickstart/).

## Core Classes and Modules

Explore the essential classes and modules:

- [String](String.html) - Text manipulation and string utilities.
- [Symbol](Symbol.html) - Named identifiers inside the Ruby interpreter.
- [Array](Array.html) - Ordered collections of objects.
- [Hash](Hash.html) - Key-value pairs for efficient data retrieval.
- [Integer](Integer.html) - \Integer number class.
- [Float](Float.html) - Floating-point number class.
- [Enumerable](Enumerable.html) - Collection traversal and searching.
- [File](File.html) - \File operations and handling.
- [IO](IO.html) - Input/output functionality.
- [Time](Time.html) - \Time representation.
- [Regexp](Regexp.html) - Regular expressions for pattern matching.
- [Range](Range.html) - Representing a range of values.
- [Exception](Exception.html) - Base class for all exceptions.
- [Thread](Thread.html) - Multithreading and concurrency.

## Language Reference

Deep dive into Ruby's syntax and features:

- [Ruby Syntax](rdoc-ref:syntax.rdoc)
- [Exceptions](rdoc-ref:exceptions.md)
- [Implicit Conversions](rdoc-ref:implicit_conversion.rdoc)

## Standard Libraries

There are some standard libraries included in Ruby that are also commonly used, such as:

- [Date](Date.html) - \Date representation.
- [JSON](JSON.html) - \JSON encoding and decoding.
- [ERB](ERB.html) - Embedded Ruby for templating.
- [Net::HTTP](Net/HTTP.html) - HTTP client library.

Use the following links to access the comprehensive set of libraries included with Ruby:

- [Standard Library Documentation](rdoc-ref:standard_library.md)
- [Maintainers](rdoc-ref:maintainers.md)

## Contribute to Ruby

Get involved with the Ruby community:

- [Contribution Guide](rdoc-ref:contributing.md)
- [Documentation Guide](rdoc-ref:contributing/documentation_guide.md)
- [Reporting Issues](rdoc-ref:contributing/reporting_issues.md)
- [Building Ruby](rdoc-ref:contributing/building_ruby.md)
- [Testing Ruby](rdoc-ref:contributing/testing_ruby.md)
- [Issue Tracker](https://bugs.ruby-lang.org/projects/ruby-master/issues)

## Additional Resources

- [Ruby Homepage](https://www.ruby-lang.org/)
- [RubyGems](https://rubygems.org/)
- [Ruby Community](https://www.ruby-lang.org/en/community/)
