/****************************************************************************************
 * Copyright (c) 2008-2010 Soren Harward <stharward@gmail.com>                          *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef APG_CONSTRAINT_TESTER
#define APG_CONSTRAINT_TESTER

#include "core/meta/Meta.h"

#include <QMutex>
#include <QString>
#include <threadweaver/Job.h>

/* This class provides a unit testing facility for the Constraints.  It would
 * have been nice to be able to leave this code entirely out of Amarok, but the
 * constraints need collections to operate and there's no convenient way to
 * create dummy or testing collections independent of the rest of the Amarok
 * program. -- sth */

class ConstraintNode;

namespace Collections {
    class QueryMaker;
}

namespace APG {
    class ConstraintTester : public ThreadWeaver::Job {
        Q_OBJECT

        public:
            ConstraintTester( Collections::Collection*, ConstraintNode* );
            ~ConstraintTester();

            // overloaded ThreadWeaver::Job functions
            bool canBeExecuted();
            bool success() const;

        public slots:
            void requestAbort();

        signals:
            void readyToRun();
            void incrementProgress();

        protected:
            void run(); // from ThreadWeaver::Job

        private slots:
            void receiveQueryMakerData( QString, Meta::TrackList );
            void receiveQueryMakerDone();

        private:
            int m_serialNumber;               // a randomly-generated serial number to help with debugging

            Collections::QueryMaker* m_qm;

            Meta::TrackList m_domain;         // tracks available to tester
            QMutex m_domainMutex;
            Meta::TrackList m_activePlaylist; // playlist generated by tester

            bool m_readyToRun;                // job execution depends on QueryMaker finishing
            bool m_abortRequested;

            QList< ConstraintNode* > m_constraints;

            // internal algorithmic functions
            void findConstraints( ConstraintNode* );
            int testConstraint( const QString&, ConstraintNode* );
            Meta::TrackPtr randomTrackFromDomain() const;
    };
} // namespace APG

#endif // APG_CONSTRAINT_TESTER
