\name{fdrperm}
\alias{fdrperm}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{FDR correction}
\description{
Provides FDR-corrected p-values, estimated from the permutation distribution of raw p-values. 
}
\usage{
fdrperm(pvals, mtdirection = "stepup")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pvals}{A list as provided by the pvalstest function }
  \item{mtdirection}{Multiple testing correction: "step-up" or "step-down"}
}
\details{"step-up" is recommended, is usually more powerful. Starts multtest correction at the least significant results (largest p-values)
"step-down" starts multtest correction at the most significant results (smallest p-values). 
}
\value{
Data frame containing information on the genomic regions, the raw p-values and the fdrs.
}

\author{Mark A. van de Wiel}

\examples{
data(cghreg)
datainfo <- data.frame(chromosomes(cghreg), bpstart(cghreg), bpend(cghreg), nclone(cghreg), avedist(cghreg))
datacgh <- regions(cghreg)
\dontrun{pvs <- pvalstest(datacgh,datainfo,group=c(7,30),groupnames=c("MSI+", "CIN+"),af=0.1,niter=10000)}
\dontrun{fdrs <- fdrperm(pvs,mtdirection="stepup")}
}