\name{CGHtest-package}
\alias{CGHtest-package}
\alias{CGHtest}
\docType{package}
\title{
Testing association of copy number with clinical variables
}
\description{
Computes summary tables, p-values and fdrs for three type of test statistics. Can also perform multiple comparisons.
}

\author{
Mark van de Wiel
Maintainer: Mark van de Wiel <mark.vdwiel@vumc.nl>
}



\examples{
data(cghreg)
datainfo <- data.frame(chromosomes(cghreg), bpstart(cghreg), bpend(cghreg), nclone(cghreg), avedist(cghreg))
datacgh <- regions(cghreg)
gfr <- groupfreq(datacgh,group=c(7,30),groupnames=c("MSI+", "CIN+"),af=0.1)
\dontrun{pvs <- pvalstest(datacgh,datainfo,teststat = "Chi-square",group=c(7,30),groupnames=c("MSI+", "CIN+"),af=0.1,niter=500)}
\dontrun{fdrs <- fdrperm(pvs,mtdirection="stepup")}
}
