`groupfreq` <-
function(datacgh,sepfile="no",dataclinvar,whclinvar=1, group,groupnames,mc="no",comparison="all",lgonly=0,af=0){
    #Xmat<-datacgh;sepfile<- "no";mc="no";group<- c(96,49);comparison<-"all"; groupnames  <- c("er-pos", "er-neg");lgonly=0;af=0.1

    levels <-sort(unique(unlist(as.list(datacgh))))
    Xmat <- as.matrix(datacgh)

    if (comparison=="all") {mcgroups <- matrix(c(1,2),ncol=2,byrow=TRUE)} else 
    {mcgroups <- matrix(comparison,ncol=2,byrow=TRUE)}
    
    if(sepfile=="yes"){orderclvar<-"no"} else {orderclvar <- "yes"}
     
    if (orderclvar == "yes"){
    groupcum <- c(0,cumsum(group))
    }
    
    lossonly <- function(x){min(x,0)}
    gainonly <- function(x){if(x>=1){return(1)} else {return(0)}}
    gainandamplification <- function(x){if(x<1){return(0)} else {return(x)}}
    countnonnull <- function(row){return(length(row[row!=0]))}
    
    if (lgonly==-1) {
        Xmat <- apply(Xmat,c(1,2),lossonly)
        levels <- c(-1,0)
    }
    if (lgonly==1){
        Xmat <- apply(Xmat,c(1,2),gainonly)
        levels <- c(0,1)
    }
    
    wr <- apply(Xmat,1,countnonnull)
    nc <-ncol(Xmat)
    whichrows <- which(wr>=nc*af)
    Xmat <- Xmat[whichrows,]
    
    
    if (orderclvar=="no"){
        clinvarname <- colnames(dataclinvar)[whclinvar]
        dcv <- dataclinvar[,whclinvar]
        whichnotna <- which(!is.na(dcv))
        dcv <- dcv[whichnotna]
        Xmat <- Xmat[,whichnotna]
        sortdcv <- order(dcv)
        dcvsort <- dcv[sortdcv]
        whlev <- levels(dcvsort)
        groupnames <- sapply(whlev,function(x)paste(clinvarname,"_",x,sep=""))
        Xmat <- Xmat[,sortdcv] #columns of data matrix are ordered according to the groups. Columns should be ordered #according to rows in clinical var data set!
        group <- sapply(whlev,function(x)length(dcvsort[dcvsort==x]))
        groupcum <- c(0,cumsum(group))
    }
    groupnames
    
    nc <-ncol(Xmat)
    
    ###Remove non-relevant groups####
    if (mc=="yes"){
        partgr <- unique(as.vector(mcgroups))
        if (length(partgr) < length(group)){
            groupn <- group[partgr]
            groupcumn <- c(0,cumsum(groupn))
            groupnames <- groupnames[partgr]
            Xmatn <- c()
            for (k in 1:length(partgr)){
                Xmatn <- cbind(Xmatn,Xmat[,(groupcum[partgr[k]]+1):(groupcum[partgr[k]+1])])
            }
            Xmat <- Xmatn
            group <- groupn
            groupcum <- groupcumn
        }
    }
    #####
    
    
    groupcumpl1 <- groupcum+1
    allreg <- c()
    for (j in 1:length(group)) allreg <- rbind(allreg,c(groupcumpl1[j],groupcum[j+1]))
    nclass <- length(levels)
    ngroup <- length(group)
    nr <- nrow(Xmat)
    ncomp <- nrow(mcgroups)

    countlev <- function(row,level){
    length(row[row==level])
    }
    
    countall <- function(row){
    sapply(levels,countlev,row=row)
    }
    
    countallrow <- function(mat){
        cmat <- c()
        for (i in 1:nrow(mat)){
            cmat <- rbind(cmat,countall(mat[i,]))
        }
        return(cmat)
    }
    
    X <- Xmat
    countallgr <- c()
    for (i in 2:length(groupcum)){
        Xmat <- X[,((groupcum[i-1]+1):groupcum[i])]
        countgroup <- countallrow(Xmat)
        countallgr <- cbind(countallgr,countgroup)
    }
    
    
    ccgall <- c()
    if (nclass==3){
        for (i in 1:length(groupnames)){
            ccg <- c(paste("nloss_",groupnames[i],sep=""), paste("nnorm_",groupnames[i],sep=""),paste("ngain_",groupnames[i],sep=""))
            ccgall <- c(ccgall,ccg)
        }
    }
    if (nclass==4){
        for (i in 1:length(groupnames)){
            ccg <- c(paste("nloss_",groupnames[i],sep=""), paste("nnorm_",groupnames[i],sep=""),paste("ngain_",groupnames[i],sep=""),paste("namp_",groupnames[i],sep=""))
            ccgall <- c(ccgall,ccg)
        }
    }
    colnames(countallgr) <- ccgall
    return(countallgr)
}
