NAME
   mkproto - make prototypes for functions


SYNOPSIS
   mkproto [-n] [-s] [-p] [ file ] ...


DESCRIPTION
   Mkproto takes as input one or more C source code files, and
produces as output (on the standard output stream) a list of function
prototypes (a la ANSI) for the external functions defined in the
given source files. This output, redirected to a file, is suitable
for #include'ing in a C source file.
   The function definitions in the original source
may be either "old-style" (in which case appropriate prototypes are
generated for the functions) or "new-style" (in which the definition
includes a prototype already).
   A -n option causes the line number where each function was defined
to be prepended to the prototype declaration as a comment.
   A -s option causes prototypes to be generated for functions declard
"static" as well as extern functions.
   A -p option causes the prototypes emitted to be only readable by ANSI
compilers. Normally, the prototypes are "macro-ized" so that compilers
with __STDC__ not defined don't see them. 
   If files are specified on the command line, then a comment specifying
the file of origin is emitted before the prototypes constructed from
that file. If no files are given, then no comments are emitted and
the C source code is taken from the standard input stream.

BUGS
   Mkproto is easily confused by complicated declarations, such as
         int ((*signal)())() { ...
or
         struct foo { int x, y; } foofunc() { ...

   Float types are not properly promoted in old style definitions,
i.e.
         int test(f) float f; { ...
should (because of the default type conversion rules) have prototype
         int test(double f);
rather than the incorrect
         int test(float f);
generated by mkproto.

   Some programs may need to be run through the preprocessor before
being run through mkproto. The -n option is unlikely to work as desired
on the output of a preprocessor.

   Typedef'd types aren't correctly promoted, e.g. for
        typedef schar char; int foo(x) schar x;...
mkproto incorrectly generates the prototype int foo(schar x) rather than
the (correct) int foo(int x).

   Functions named "inline" with no explicit type qualifiers are not
recognized.

SEE ALSO
   cc(1), lint(1)

AUTHOR
   Eric R. Smith.

NOTE
   There is no warranty for this program (as noted above, it's guaranteed
to break sometimes anyways!). Mkproto is in the public domain.
