
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/lib/RCS/xtutil.h,v 2.2 92/10/19 16:55:46 ken Exp $
 *
 * $Log:	xtutil.h,v $
 * Revision 2.2  92/10/19  16:55:46  ken
 * Trivial change
 * 
 * Revision 1.1  92/10/19  16:37:12  ken
 * Initial revision
 * 
 */

/* WidgetSpec is used in tables to create widget trees
 * using BuildWidgetTree. 
 */

typedef struct _WidgetSpec {
    unsigned long	flags;
    String		name;
    Widget		(*create)(Widget, String, ArgList, Cardinal);
} WidgetSpec;

#define W_PARENT	0x100
#define W_LAST_CHILD	0x010
#define W_NO_MANAGE	0x001


/* Prototypes */

/* xtutil.c */
void	GetValue (String resource, void *dest, Widget widget);
void	SetValue (String resource, XtArgVal val, Widget widget);
void	CenterWidget (Widget widget, int x, int y);
void	CenterWidgetOverCursor (Widget widget);
void	PositionDialogCB (Widget w, XtPointer closure, XtPointer callData);
Widget	ShellOfWidget (Widget w);
Widget	TopLevel (Widget w);
XVisualInfo	*FindDeepestPseudoVisual (Display *display, Screen *screen);
XVisualInfo	*FindRootVisual (Display *display, Screen *screen);
void	SwallowCells (Display *display, Colormap cmap, Pixel *holdPix, int *holdNum);
void	CopyColormap (Display *display, Colormap srcmap, Colormap dstmap, int ncolor);
void	MirrorColormap (Display *display, Colormap srcmap, Colormap dstmap, int ncolor);
void	AllocBlack (Display *display, Screen *screen, Colormap cmap);
void	QueryBackground (Widget w, XColor *bgc);
void	GrabUntilClick (Widget w, XEvent *ev);
void	ManageCB (Widget w, XtPointer closure, XtPointer callData);
void	UnmanageCB (Widget w, XtPointer closure, XtPointer callData);
void	SensitizeCB (Widget w, XtPointer closure, XtPointer callData);
void	DesensitizeCB (Widget w, XtPointer closure, XtPointer callData);
void	RemoveKeyCB (Widget w, XtPointer closure, XtPointer callData);
void	BuildWidgetTree (Widget parent, WidgetSpec *ws);
Widget	BuildOneWidget (Widget parent, char *name, Widget (*create )(Widget,String,ArgList,Cardinal ), int unmanaged);
Widget	GetWidget (char *name);
Widget	CheckWidget (char *name);
void	AddWidgetConverter (XtAppContext app);
