
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/lib/RCS/glutil.h,v 2.2 92/10/19 16:55:33 ken Exp $
 *
 * $Log:	glutil.h,v $
 * Revision 2.2  92/10/19  16:55:33  ken
 * Trivial change
 * 
 * Revision 1.1  92/10/19  16:37:07  ken
 * Initial revision
 * 
 */

/* These vector and quaternion macros complement similar
 * routines.
 */

#define vset(a,x,y,z)	(a[0] = x, a[1] = y, a[2] = z)
#define vcopy(a,b)	(b[0] = a[0], b[1] = a[1], b[2] = a[2])
#define vzero(a)	(a[0] = a[1] = a[2] = 0)
#define vadd(a,b,c)	(c[0]=a[0]+b[0], c[1]=a[1]+b[1], c[2]=a[2]+b[2])
#define vsub(a,b,c)	(c[0]=a[0]-b[0], c[1]=a[1]-b[1], c[2]=a[2]-b[2])
#define vdot(a,b)	(a[0]*b[0] + a[1]*b[1] + a[2]*b[2])
#define vlength(a)	fsqrt(vdot(a,a))
#define vnormal(a)	vscale(a, 1/vlength(a))

#define qset(a,x,y,z,w)	(a[0] = x, a[1] = y, a[2] = z, a[3] = w)
#define qcopy(a,b)	(b[0] = a[0], b[1] = a[1], b[2] = a[2], b[3] = a[3])
#define qzero(a)	(a[0] = a[1] = a[2] = 0, a[3] = 1)
#define qadd(a,b,c)	(vadd(a,b,c), c[3]=a[3]+b[3])

#define	YMAXSTEREO	491
#define	YOFFSET		532

extern Matrix idmatrix;


/* The Trackball package gives that nice 3D rotation interface.
 * A trackball structure is needed for each rotated scene.
 */

typedef struct Trackball {
    float	qrot[4];
    float	qinc[4];
    float	trans[3];
    float	scale[3];
    float	ballsize;
    float	lastx, lasty;
} Trackball;


/* Prototypes */

/* glutil.c */
void	vscale (float *v, float s);
void	vhalf (const float *v1, const float *v2, float *half);
void	vcross (const float *v1, const float *v2, float *cross);
void	vreflect (const float *in, const float *mirror, float *out);
void	vtransform (const float *v, Matrix mat, float *vt);
void	vtransform4 (const float *v, Matrix mat, float *vt);
void	mcopy (Matrix m1, Matrix m2);
void	mmult (Matrix m1, Matrix m2, Matrix prod);
void	minvert (Matrix mat, Matrix result);
void	LinSolve (const float *eqs [], int n, float *x);
void	qnormal (float *q);
void	qmult (const float *q1, const float *q2, float *dest);
void	qmatrix (const float *q, Matrix m);
float	ProjectToSphere (float r, float x, float y);
void	CalcRotation (float *q, float newX, float newY, float oldX, float oldY, float ballsize);
float	ScalePoint (long pt, long origin, long size);
void	TrackballReset (Trackball *tball);
Trackball	*TrackballInit (void);
void	TrackballSetMatrix (Trackball *tball);
void	TrackballFlip (Trackball *tball, int axis);
void	TrackballSpin (Trackball *tball);
void	TrackballStopSpinning (Trackball *tball);
int	TrackballSpinning (Trackball *tball);
void	TrackballSetPosition (Trackball *tball, float newx, float newy);
void	TrackballRotate (Trackball *tball, float newx, float newy);
void	TrackballPan (Trackball *tball, float newx, float newy);
void	TrackballZoom (Trackball *tball, float newx, float newy);
void	TrackballCopy (Trackball *src, Trackball *dst);
void	MouseOnTrackball (XEvent *event, unsigned width, unsigned height, Trackball *tball);
void	DumpRLEImage (int ox, int oy, int sx, int sy, char *fname);
void	DumpBinaryImage (int ox, int oy, int sx, int sy, char *fname);
void	ViewMatrix (Matrix m);
int	ViewAxis (int *direction);
void	StereoPerspective (int fovy, float aspect, float near, float far, float converge, float eye);
