
All About Bob


About This Manual

Bob was created for the Graphics and Visualization Lab of the Army
High Performance Computing Research Center.  The program and its
documentation were written by Ken Chin-Purcell.  One of the missions
of the AHPCRC is to develop visualization techniques for viewing the
large simulations run on the AHPCRC's massively parallel
supercomputers.

The development of Bob is supported by the Army Research Office
contract number DAALO3-89-C-0038 with the University of Minnesota Army
High Performance Computing Research Center.

This manual was written using SGI Showcase, which is also probably the
best method for viewing it.  The screen shots used in this manual can
take a long time to print.  If you need hardcopy, try using the
Showcase option draft when printing.  This will create black and white
versions of the figures, which may print faster.


Introduction

Bob was born out of frustration.  With our existing tools we shot
rays, marched cubes, and sliced and diced as fast as possible, but we
were unable to keep up with the simulations being computed at the
AHPCRC.  A browsing tool was needed that would run on a workstation,
create acceptable images of three dimensional volumes, render large
sections of still larger data sets, and was interactive and fast.

The main idea behind Bob is to squeeze as much interactivity as
possible out of the Iris graphics hardware. Using Bob on an Iris VGX,
volumes in the size range of 64 cubed can be rendered at one to ten
frames per second.  Data sets of this dimension and lower can easily
be looked at in their entirety.  For larger data sets, Bob gives you
the option of either rendering a part of the total volume, subsampling
a larger section (e.g. view every third voxel), or waiting while the
larger volume is rendered.


Hardware & Operating System

Bob will work best on an SGI 4D series computer that is capable of
alpha blending.  This includes Indigo, Elan, GTX, and VGX graphics
hardware.  Alas, the Personal Iris does not support alpha blending.
Maximum value rendering does not require blending hardware, but does
require a z-buffer.  If your machine lacks both alpha blending and
z-buffering, then as far as Bob is concerned you are stuck.

On the GTXB Bob unfortunately displays artifacts near the edge of
opaque regions.  This problem only occurs when the alpha value drops
to zero, and can be worked around by setting the alpha value to a
small value instead of zero.  Maximum value rendering is included for
those users without blending, but it a poor second cousin.  The
preferred hardware for Bob is Elan or VGX graphics.

Bob was written using Motif and the GLX widget, and thus needs to run
under IRIX 4.0.1 or later.

Bob will benefit from large memory and fast disks.  Bob holds three
copies of the data brick in memory (transposed for each principle
axis), so a good estimate of Bob's total memory requirement is one
megabyte plus three times the maximum volume that will be rendered
(note that this can be a subsection of the total data set) .  Since
only one of the bricks is used for rendering a given scene,
performance is acceptable if physical memory is a smaller than total
memory.


File Format

The name "Bob" stands for "Brick Of Bytes", which is Bob's data
format.  In order to render quickly, Bob requires the data to be
arranged in a three dimensional array, forming a brick with right
corners.  Each element of the array is used to color a corresponding
grid cell in the data volume.  In graphics terminology, each grid cell
is called a voxel, the term coming from volume pixel.  By setting some
of the voxels to be transparent, and others to be translucent and
colored, an image can be made of the interior.

The data file should contain one byte per voxel, with the bytes stored
in one continuous array.  Bob does not use a file header.  The X
direction varies fastest, then Y and lastly Z.  In other words, the
data file consists of Z planes, each plane containing Y rows, each row
X bytes long.

For many users, like those with finite difference simulations or
cat-scan image data, the "brick of bytes" data format should be easy
to generate.  However, if your data set is curve-linear or
unstructured, you will need to rasterize your data into a brick ahead
of time.  One way to do this would be to create a series of slices,
then concatenate the slices into a brick of voxels.  Each slice would
be a plane of bytes, with each byte value being interpolated from the
simulation data.


Getting Started

Once you have your brick, lets say 256 by 256 by 128 in size, to use
Bob:

	bob -s 256x256x128 mybrick

Bob will initially display a 32 by 32 by 32 section of the data set.
The image can be rotated, panned and zoomed with the mouse.  A
separate "dimension" dialog allows the rendered section of the data
volume to be moved, changed in size, or subsampled.  A small "finder"
view in the dimension dialog shows the rendered volume in relation to
the data volume.

Bob can create a series of images that can be later compiled into a
movie.  To render a time series of data, place each time step in a
separate file and then list the files on the command line.  There is
also some flexibility in the data format.  Bob can skip over a header
section, and multiple bricks can be stored in the same file.

The Bob man page (see appendix) lists the command line options in
detail.


Volume Rendering

Volumes of data can be rendered using many techniques. Usually there
is a trade-off between speed and image quality. By alpha blending
planes of polygons, Bob stresses speed. Alpha blending is a technique
for rendering semi-transparent graphics. Computer images consist of
pixels, where each pixel has a red, green and blue value.  These color
values are stored in a section of memory called the "frame buffer",
and all graphics commands eventually result in loading new color
values into the frame buffer, changing the color of pixels and thus
the image.  When alpha blending, in addition to specifying red, green
and blue color values, the alpha value determines how to blend a color
with the existing color in the frame buffer.

For each data value, or voxel, in the volume, Bob draws an alpha
blended polygon of pixels. By drawing sheets of polygons from back to
front, Bob simulates what the brick of data would look like if some of
the voxels were opaque and others were clear. The alpha value becomes
in effect the opacity of a particular voxel.

Using Iris VGX graphics, Bob can always achieve sub-second rendering
rates for volumes up to 64 cubed, and, depending on the size of the
opaque regions, can often achieve sub-second rendering rates up to 128
cubed.  Whenever a new volume is chosen, or the alpha map changes, Bob
scans and marks the volume for blank regions.  When rendering, Bob
will skip these blank regions, resulting in sometimes dramatic
increases in rendering speed.  Therefore, in the interest of fast
images, it pays to set the alpha value of uninteresting regions to
zero.

The Maximum Value option renders the volume using the z-buffer instead
of alpha blending, and thus can be used on the Personal Iris.  When
using the maximum value technique, a pixel is written to the screen if
its "alpha" value is greater than the alpha values behind it.  The
effect is to expose the regions of high value in the volume.  In this
mode the alpha channel does not blend a pixel with its background, it
only controls whether a pixel is written or not.

The image produced by maximum value rendering is often hard to
interpret, because low value regions that are in front of high value
regions disappear.

The polygon technique sometimes introduces rendering artifacts, such
as jagged edges and aliasing patterns on thin opaque sheets. Moreover,
the brightness of the image will change slightly depending on the
viewing angle. Bob has two options that reduce artifacts (see "soft
edges" and "interpolate"), but occasionally, particularly for small
volumes, aberrations are unavoidable. In its defense though, the alpha
blending method is faster than ray tracing, and the results are often
comparable. Bob is targeted at impatient researchers.
 
Bob's functionality overlaps SGI Explorer's splat volume renderer.
Bob has a more restrictive file format, but is faster and can handle
larger data sets.  The Explorer splat renderer can be integrated with
other geometry.  Both Explorer and Bob can produce rendering
artifacts.


Color and Alpha

Bob works hand in hand with Icol, a color map editor.  Icol creates
tables of color for other applications.  Bob uses these tables to
construct color and opacity from a single voxel value.  You will need
to be familiar with Icol in order to interactively specify colors and
alpha values.  Icol communicates with Bob, so that when a new color
map is created the changes are automatically passed on to Bob.

In order to render a volume of data, Bob needs to know how to map the
voxel value to both a color and alpha value.  This is done using two
tables, the color map and the alpha map.  Unless an alpha map is
specified, Bob constructs the alpha map from the brightness of the
color map.  This is often the desired result, with dark colors being
more transparent and bright colors more opaque.  This mode is called
"Auto Alpha" in Bob, and can be toggled on and off.

Experienced users may want to specify the alpha values separately.  If
an alpha map is specified, either on the command line or using the
"Alpha Only" mode in Icol, then Bob will turn off "Auto Alpha".

Icol's YUV color space is particularly useful when volume rendering.
YUV space is a linear transform of RGB, such that Y is the brightness
and U and V encode color.  In approximate terms, U encodes the blue
channel and V encodes red.  The best feature of YUV space is that
brightness can be specified independently from color.  This gives
direct control over opacity when using the "Auto Alpha" mode.

Although YUV space is handy for controlling brightness independently
from hue, it can be hard at first to locate saturated colors.  The key
is to remember that blue is the least bright, followed by red, purple,
green, cyan, and yellow.  So if your Y value is relatively bright (say
0.70) you won't have much luck finding a deep blue, but you could get
close to yellow.  In YUV space, pure blue has a Y value of 0.11, U
equals +0.50, and V equals -0.7 (maximum U, minimum V).  Red is Y
equals 0.30, U equals -0.16, and V equals +0.50 (minimum U, maximum
V).  Green is Y equals 0.59, U equals -0.32, and V equals -0.41
(minimum U, minimum V).

Another useful Icol technique is to flip back and forth between RGB
mode and YUV mode, finding pure colors in RGB and modifying the
brightness in YUV.  Try also dragging knot points in the color map to
new locations.

Remember also that pure black will cause Bob to skip rendering that
value.  Often the liberal use of black values will both speed up
rendering and create a clearer picture.

To specify the alpha value independently from color, use the Alpha
mode of Icol.  When an alpha map is modified in Icol, the changes are
automatically passed on to Bob, like the color map.  Bob will turn off
Auto Alpha mode when it is given an alpha map, so that subsequent
changes to the color map will not effect the alpha map.

Using a separate alpha map is useful for hilighting ranges of values
in the volume.  While knot points are usually the best way to specify
a color map, using brushes to sketch the alpha map in Icol can quickly
accentuate or hide volume regions in Bob.

By default, Icol communicates every change in the color or alpha map
to Bob.  For larger volumes this can be tiresome, because Bob scans
the volume for blank regions whenever new alpha values are specified.
By turning off the Auto Set Property option in Icol (in the Mode
menu), Icol keeps changes to itself.  To explicitly set the color map,
use the Set Colormap Property command (in the Control menu) in Icol.


Main Window

Bob's interface consists of a main window, where the volume rendering
takes place, and two dialogs, one for controlling the volume
dimensions and the other for controlling animation.  The dialogs can
be hidden and displayed as needed.

The main window is divided into a rendering area on the left and a
control area on the right.  The control area has a menu bar, a scale
adjustment for the alpha values, a scale for the frame number (used
for multiple data sets), and two lists.  The top list contains the
data files, and the bottom list contains dimensions settings.  You can
resize the main window as needed.

The "Alpha Attenuation" slider adjusts the scale factor applied to the
alpha values.  This scale is handy for adjusting the overall
transparency of a picture, particularly when scaling up or down in
volume size.  A volume that is twice as large will be approximately
twice as opaque, which may not be desired.  The alpha attenuation
scale can counter this effect.

The frame slider can be used to skip to a new data frame.  If only one
data brick was specified on the Bob command line, then there will be
only one frame.  If there is one frame per file, then each increment
of the frame slider will open a new file.  If there is more than one
data brick per file, the frame slider will walk through the bricks in
each file in order.

The file list contains one entry per data file.  Clicking on a file
name causes Bob to read in the first data brick in that file.  Use the
frame slider to access subsequent bricks if there is more than one
brick per file.  The current dimension settings are used to read the
new data.  There is currently no way to add or delete files from the
list without restarting Bob.

The dimension list is a convenient place to remember choice locations
in a large data file.  The Dimension menu commands add and delete
entries in the dimension list.  Each entry defines all of the settings
from the dimension dialog.  Selecting a new entry causes Bob to read a
volume from the current data file using those dimension settings.


3D Manipulation

Both the finder and volume cube are rotated and moved using the same
mouse techniques.  Button 1 of the mouse is used to rotate the volume,
button 2 pans the volume in the plane of the screen, and button 3 will
zoom the volume towards or away from the viewer.  In all three cases,
start moving the volume by clicking with the button, hold the button
down as you move to drag the volume, and let up to finish.

The rotation is modeled using a trackball, positioned in the center of
the window.  Clicking in the center of the volume window will rotate
the image about X and Y axes, whereas clicking near the edge rotates
around the Z axis.  If you keep moving the mouse as the button is
released, the volume is kicked and will keep rotating in that
direction.  To stop unwanted rotation, click and release in the same
location.

Panning the volume in the plane of the screen is straightforward.
Move the mouse in the vertical direction to zoom the volume closer or
farther away.

Bob will automatically cut the resolution of the volume in order to
achieve an interactive frame rate while the volume is being
manipulated with the mouse.  After the mouse button is released the
image is drawn at full resolution.


Dimension Dialog

An often used feature of Bob is the ability to render only part of the
whole data set.  The dimension dialog controls the portion of the data
set that is viewed in the main window.

The viewed volume dimensions are specified by its size, the center of
the volume, and the stride at which the volume is read.  The stride
value allows a large data set to be subsampled.  For example, a 30 by
30 by 30 volume taken with a stride of three will read every third
value of a 90 by 90 by 90 volume from the data set.  Because a 30
cubed volume will render much faster than a 90 cubed one, the stride
setting is useful for browsing a large area.

The finder view next to the dimension sliders shows the viewed volume
in relation to the data set.  The cube will change color and position
when a new volume is read from file and/or analyzed.  As the volume is
read, a red plane progresses across the cube.  The volume is being
transposed and interpolated, if needed, while the cube is red.  The
cube builds face by face in light blue as the volume is analyzed for
opaque regions, and finally the volume is rendered and the cube
returns to a darker shade of blue.

When one of the dimension dialog sliders is changed, the cube responds
in size and also turns a yellow color to indicate that it is out of
sync with the rendered volume in the main window.

The consistency check for dimension settings is always done in the
same order.  The volume size values are never changed.  Next the
center of the volume is adjusted to be within the data set.  Finally
the stride is decreased to fit the data set.  Therefore, if you want
to increase the stride to fill the volume, you first must decrease the
volume size.

For reference, the rotation of the finder cube is coupled to the
rotation of the volume.  The finder cube can be used as a remote
method of rotating the volume, although the finder cube cannot be
kicked.

Control Menu

To send mail to the author, chose the Mail Comment command from the
About Bob dialog box.

The current set of files and dimension settings can be saved in a text
file using the Save command.  If the file's name is either Bobfile or
bobfile Bob will automatically read those settings if run in that
directory, similar to the behavior of make.  A settings file can be
read in by using the Open command.

If you have thousands of file names you may want to start up Bob with
the proper command line aguements and just one file, and save the
settings to Bobfile.  Then add the rest of the file names to the end
of Bobfile.  For example:

	/bin/ls data.* >> Bobfile

Then run Bob with no command line aguements.  This technique will work
around the line length limit of the shell when many files are selected
using a wild card.

The Start Icol command will create two Icol color table editors, one
for color and one for alpha.  If you don't want to use alpha, then you
may want to either iconify or exit the Icol in alpha mode.  This
command is just a convenience; you can also run icol from the command
line, as in:

	icol &
	icol -m alpha &

The Animate and Dimension commands open the animation and dialog
commands respectively.  The Exit command quits the application,
currently without confirmation.


View Menu

For those users with stereo hardware, the Stereo command will take
over the screen with a stereo view of the volume.  The pointer will
probably start off screen; try moving the pointer down until you see
it.  The volume can still be rotated and moved as before.  To exit
stereo viewing, press any keyboard key.  Stereo does not work with
maximum value rendering, although it might some day.

The Home View and Flip commands reposition the volume.  The axes for
the flip commands are in screen space, not the coordinate system of
the volume.  The X axis is horizontal, the Y axis is vertical, and the
Z axis comes out of the screen towards the user.

Bounding Box, Color Bar and Annotation toggle the drawing of extra
items in the rendering window.  The line to the left of the color bar
is a small graph of the alpha table.  The Annotation toggle controls
the display of the axis labels and volume limits.


Mode Menu

The toggle options in the Mode menu adjust the volume rendering.
Normally the drawing is done using double buffering, but for for large
volumes that take more than a second to render this can be tiresome.
When Double Buffer is turned off you can also see the volume being
painted, which can be instructive in itself.

Watching an image paint in stereo mode when double buffering is turned
off can be disconcerting.  Since the stereo image needs to be drawn
twice, the right eye will see the image fill in before the left eye.

Maximum Value switches the rendering algorithm from alpha blending to
maximum value.  When an image is rendered using the maximum value
technique a voxel is drawn only if its value is greater than the
voxels behind it.  This is default mode if blending hardware is
unavailable.  Stereo cannot be used in maximum value mode, and the
soft edges option is meaningless.

Auto Alpha controls whether the alpha map is constructed from the
brightness of the color map.  If Auto Alpha is turned off, a separate
alpha map editor should be used.

Soft Edges can take away some of the rendering artifacts that occur at
the edge of the volume.  When Soft Edges is on the voxels on the
perimeter of the volume are faded to zero alpha.  The perimeter data
is lost, but the image sometimes looks better.

An option that usually has a larger impact on image quality is
Interpolate.  When Interpolate is on an extra set of planes is
interpolated and drawn.  This can greatly reduce artifacts that arise
from small, sharp contrasts in the data set.  The penalty for
Interpolate is a doubling of rendering time and a doubling of memory.


Dimensions Menu

By default, every time a new setting is chosen in the dimension dialog
the volume is read from disk and analyzed.  To delay reading the data
turn off the Active toggle.  This can be useful when positioning a
large volume, where you might want to adjust several sliders in the
dimension dialog before waiting for the data to be read in and
analyzed.  To trigger reading of a new volume, use the Apply command.

The dimension list in the main window can be edited using the Add
Entry and Delete Entry commands.  The Delete Entry command deletes the
currently selected item, or the top item if none are selected.


Animation

At the AHPCRC Bob is integrated into a system for making on line
movies using xraz and raw animation disks.  With this method images
are saved sequentially to a raw disk partition and later viewed using
xraz.  Other sites may want to save each image in a separate file, and
then convert the raw image files to their preferred image format for
viewing.

In either case, the animation dialog controls the animation process.
With each frame the volume can be rotated about an axis and the frame
can be incremented.  The axis of rotation is specified in screen
coordinates, not the volume's coordinates.  X is horizontal, Y is
vertical, and Z comes out of the screen towards the viewer.  The axes
values and the rotation increment can be floating point values.

The X, Y and Z axes of the volume can be entered by pressing the
respective axes buttons.  Use this feature to rotate the volume in its
own coordinate system.

Animation images can be saved to a file, piped to a command, or a
shell command can be executed on every frame.  To pipe the output to a
command, type '|' and the shell command in the file name entry.  Be
sure that the first character is the pipe symbol '|'.  To execute a
command that doesn;t require the image data, type '!' and the shell
command in the file name entry.  Like the pipe command, be sure that
the first character is the symbol '!'.

To save an animation, decide the number of frames to be saved and the
size of the image.  Important: Position the volume window so that no
other windows obscure it.  Since the final image is taken from the
front buffer, any obscuring windows will clobber a section of the
image.

Raw disk users will want to specify an animation drive, such as
/dev/anim0 or /dev/anim1.  To place the animation somewhere else than
the beginning of the drive, specify an offset.  The offset number can
contain the letters 'k' or 'm', which stand for kilo and mega
respectively.  For example, to start an animation 100 megabytes into
the drive, enter '100m' for the offset.  Offsets for the AHPCRC
animation drives should be in multiples of 4k (the disk drive block
size).

To use individual files, enter a file name with a '%d', which will be
replaced with the image number.  For example, to generate the series
of files ras.000, ras.001, ras.002..., enter 'ras.%03d' for the file
name.  Unless Bob is configured to generate files for animation
drives, the file format will be interlaced rgb bytes, as in
rgbrgbrgb....  To convert to the sgi image format, say for a 512 by
512 image, use the command:

	frombin ras.000 sgi.000 512 512 3

The SGI program movie could then be used to display the converted
images as a movie loop.
