/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

#include "nurbh.h"

/*---------------------------------------------------------------------------*/
extern void nrb_phigsplus(C(PR_nurb *)nrb_in)
PreANSI(PR_nurb *nrb_in)
{
#ifdef VMS

#include <phigs.h>

  /*
    Create a structure element in PHIGS PLUS using info in NURB
  */
  Pint tempx, tempy;
  PPsurftrimdef NoTrim;
  Pfloatlst uknots, vknots;
  PPpointgrid34 cont_grid;
  PPpointlst34 ppts;
  PR_dir *tdir;
/*****
   printf("NRB_PHIGSPLUS\n");
   nrb_dump(stdout,nrb_in);
*****/
  if (nrb_in->pf_v.pf_n <= 1) {   /*Its a curve!*/
    tdir = &nrb_in->pf_u;
    uknots.number= tdir->pf_nt;
    uknots.floats = &tdir->pf_kk->knots;

    ppts.type = PPRATIONAL;
    ppts.number = tdir->pf_n;
    ppts.pts34.pt4d  = nrb_in->pf_ppp->pts;

    ppnunibspcurv(tdir->pf_k, &uknots, &ppts, tdir->pf_kk->knots[0],
	       tdir->pf_kk->knots[( tdir->pf_nt ) - 1]);
    return;
  }

  NoTrim.number = 0;
  NoTrim.loop = NULL;

  uknots.number = nrb_in->pf_u.pf_nt;
  uknots.floats = &nrb_in->pf_u.pf_kk->knots;

  vknots.number = nrb_in->pf_v.pf_nt;
  vknots.floats = &nrb_in->pf_v.pf_kk->knots;

  cont_grid.type = PPRATIONAL;
  cont_grid.u_num = nrb_in->pf_u.pf_n;
  cont_grid.v_num = nrb_in->pf_v.pf_n;

  cont_grid.pts34.pt4d = nrb_in->pf_ppp->pts;

  ppnunibspsurf(nrb_in->pf_u.pf_k, nrb_in->pf_v.pf_k, &uknots, &vknots,
	       &cont_grid, nrb_in->pf_u.pf_kk->knots[0],
	       nrb_in->pf_u.pf_kk->knots[ nrb_in->pf_u.pf_nt - 1],
	       nrb_in->pf_v.pf_kk->knots[0],
	       nrb_in->pf_v.pf_kk->knots[ nrb_in->pf_v.pf_nt - 1], &NoTrim);

#endif
}

