/* This is file /ptk_project/include/tranfns.h created by Extract */
/* Date: */

/*-------------------------------*/
/*  Including from:/ptk_project/source/library/tran.c  */

extern boolean ptk_equal ARGS((  Pfloat  one,   Pfloat  two));

extern Ppoint ptk_point ARGS((  Pfloat  x,   Pfloat  y));

extern Ppoint3 ptk_point3 ARGS((  Pfloat  x,   Pfloat  y,   Pfloat  z));

extern Pvector ptk_vector ARGS((  Pfloat  x,   Pfloat  y));

extern Pvector3 ptk_vector3 ARGS((  Pfloat  x,   Pfloat  y,   Pfloat  z));

extern Plimit ptk_limit ARGS((  Pfloat  xmin,   Pfloat  xmax,   Pfloat  ymin,
                          Pfloat  ymax));

extern Plimit3 ptk_limit3 ARGS((  Pfloat  xmin,   Pfloat  xmax,   Pfloat  ymin,
                            Pfloat  ymax,   Pfloat  zmin,   Pfloat  zmax));

extern Ppoint3 ptk_vec3topt3 ARGS((  Pvector3 *  vec));

extern Pvector3 ptk_pt3tovec3 ARGS((  Ppoint3 *  pt));

extern Pfloat ptk_dotv ARGS((  Pvector3 *  v1,   Pvector3 *  v2));

extern Pvector3 ptk_crossv ARGS((  Pvector3 *  v1,   Pvector3 *  v2));

extern boolean ptk_nullv ARGS((  Pvector3 *  vec));

extern Pfloat ptk_modv ARGS((  Pvector3 *  vec));

extern Pvector3 ptk_unitv ARGS((  Pvector3 *  vec));

extern Pvector3 ptk_scalev ARGS((  Pvector3 *  vec,   Pfloat  scale));

extern Pvector3 ptk_subv ARGS((  Pvector3 *  p1,   Pvector3 *  p2));

extern Pvector3 ptk_addv ARGS((  Pvector3 *  p1,   Pvector3 *  p2));

extern boolean ptk_equalpoint ARGS((  Ppoint *  pt1,   Ppoint *  pt2));

extern boolean ptk_equalpoint3 ARGS((  Ppoint3 *  pt1,   Ppoint3 *  pt2));

extern boolean ptk_equalvector ARGS((  Pvector *  vec1,   Pvector *  vec2));

extern boolean ptk_equalvector3 ARGS((  Pvector3 *  vec1,   Pvector3 *  vec2));

extern void ptk_unitmatrix ARGS((  Pmatrix  matrix));

extern void ptk_unitmatrix3 ARGS((  Pmatrix3  matrix));

extern boolean ptk_equalmatrix ARGS((  Pmatrix  mat1,   Pmatrix  mat2));

extern boolean ptk_equalmatrix3 ARGS((  Pmatrix3  mat1,   Pmatrix3  mat2));

extern void ptk_transposematrix3 ARGS((  Pmatrix3  matrix,   Pmatrix3  result));

extern void ptk_multiplymatrix3 ARGS((  Pmatrix3  matrix1,   Pmatrix3  matrix2,
                            Pmatrix3  result));

extern void ptk_concatenatematrix3 ARGS((  Pcomptype  operation,
              Pmatrix3  matrix1,   Pmatrix3  matrix2,   Pmatrix3  result));

extern void ptk_shift3 ARGS((  Pvector3 *  shift,   Pcomptype  operation,
                         Pmatrix3  matrix));

extern void ptk_scale3 ARGS((  Pvector3 *  scale,   Pcomptype  operation,
                         Pmatrix3  matrix));

extern void ptk_rotatecs3 ARGS((  Pfloat  costheta,   Pfloat  sinetheta,
                            ptkeaxistype  axis,   Pcomptype  operation,
                            Pmatrix3  matrix));

extern void ptk_rotate3 ARGS((  Pfloat  rotation,   ptkeaxistype  axis,
                          Pcomptype  operation,   Pmatrix3  matrix));

extern void ptk_shear3 ARGS((  ptkeaxistype  shearaxis,   ptkeaxistype  sheardir,
                         Pfloat  shearfactor,   Pcomptype  operation,
                         Pmatrix3  matrix));

extern void ptk_rotatevv3 ARGS((  Pvector3 *  v1,   Pvector3 *  v2,
                            Pcomptype  operation,
                            Pmatrix3  matrix,   Pint * error));

extern void ptk_rotateline3 ARGS((  Ppoint3 *  p1,   Ppoint3 *  p2,
                              Pfloat  theta,   Pcomptype  operation,
                              Pmatrix3  matrix,   Pint * error));

extern Ppoint4 ptk_pt3topt4 ARGS((  Ppoint3 *  point));

extern Ppoint3 ptk_pt4topt3 ARGS((  Ppoint4 *  point));

extern Ppoint4 ptk_transform4 ARGS((  Pmatrix3  matrix,   Ppoint4 *  point));

extern Ppoint3 ptk_transform3 ARGS((  Pmatrix3  matrix,   Ppoint3 *  point));

extern void ptk_matrixtomatrix3 ARGS((  Pmatrix  mat,   Pmatrix3  mat3));

extern void ptk_outputmatrix3 ARGS((  FILE *  fileptr,   Pmatrix3  matrix,
                                Pchar *  string));

extern void ptk_box3tobox3 ARGS((  Plimit3 *  box1,   Plimit3 *  box2,
                             boolean  preserve,   Pcomptype  operation,
                             Pmatrix3  matrix,   Pint * error));

extern void ptk_accumulatetran3 ARGS((  Ppoint3 *  fixed,   Pvector3 *  shift,
                                  Pfloat  rotx,   Pfloat  roty,
                                  Pfloat  rotz,   Pvector3 *  scale,
                                  Pcomptype  operation,
                                  Pmatrix3  matrix));

extern void ptk_evalvieworientation3 ARGS((  Ppoint3 *  viewrefpoint,
                                      Pvector3 *  viewplanenormal,
				      Pvector3 *  viewupvector,
                                      Pcomptype  operation,
                                      Pmatrix3  matrix,   Pint * error));

extern void ptk_evalviewmapping3 ARGS((  Plimit3 *  wlimits,   Plimit3 *  vlimits,
                                  Pprojtype  viewtype,
                                  Ppoint3 *  refpoint,   Pfloat  vplanedist,
                                  Pcomptype  operation,   Pmatrix3  matrix,
                                  Pint * error));

extern void ptk_stackmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_unstackmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_examinestackmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_3ptto3pt ARGS((  Ppoint3 *  p1,   Ppoint3 *  p2,   Ppoint3 *  p3,
                           Ppoint3 *  q1,   Ppoint3 *  q2,   Ppoint3 *  q3,
                           Pcomptype  operation,   Pmatrix3  matrix,
                           Pint * error));

extern void ptk_0to3pt ARGS((  Ppoint3 *  origin,   Pvector3 *  xdirn,
                Pvector3 *  ydirn,   Pcomptype  operation,   Pmatrix3  matrix));

extern void ptk_oto3pt ARGS((  Ppoint3 *  origin,   Pvector3 *  xdirn,
               Pvector3 *  ydirn,   Pcomptype  operation,   Pmatrix3  matrix));

extern void ptk_invertmatrix3 ARGS((  Pmatrix3  a,   Pmatrix3  ainverse,
                                Pint * error));
