/*Scian.h
  Standard header for scian.
  Eric Pepke
  February 9, 1990
*/

#include "machine.h"

#ifdef STDLIB
#include <stdlib.h>
#endif
#include <ctype.h>
#ifdef INTERACTIVE
#include <device.h>
#include <fcntl.h>
#endif
#ifdef GRAPHICS
#ifdef FONTS4D
#include <fmclient.h>
#endif
#include <gl.h>
#if MACHINE == IRIS4D
#include <gl/addrs.h>
#include <gl/cg2vme.h>
#include <gl/get.h>
#endif
#else
typedef float Matrix[4][4];
#endif
#ifdef MALLOCH
#include <malloc.h>
#else
extern void *malloc();
#endif
#include <math.h>
#include <sys/types.h>
#ifdef SOCKETS
#include <netdb.h>
#include <netinet/in.h>
#endif
#include <stdio.h>
#include <string.h>
#include <sys/dir.h>
#include <sys/file.h>
#if MACHINE == RS6000
#include <sys/machine.h>
#endif
#include <sys/param.h>
#ifdef SOCKETS
#include <sys/socket.h>
#endif
#include <sys/stat.h>
#include <sys/times.h>
#include <sys/types.h>
#include <termio.h>

typedef short Bool;			/*Our boolean stuff*/
#define true 1
#define false 0

extern char **fonts;
extern int nFonts;

/*C Variable types*/
typedef float real;

/*Bits for flags*/
#define ISOBJECT 	0x80000000	/*1 if it is an object, 0 if not*/
#define REALARRAY	1		/*Array of real values*/
#define STRING		2		/*Single string value*/
#define INTEGER		3		/*Single integer value*/
#define REAL		4		/*Single real value*/
#define LIST		5		/*List of things*/
#define PALETTE		6		/*Palette of colors*/
#define MATRIX		7		/*Transformation matrix*/
#define WINDOW		8		/*Window*/
#define PICTURE		9		/*Picture of graphical objects*/
#define OBJECTARRAY	10		/*Array of objects*/

/*Object predicate, returns true iff theObj is an object*/
#define IsObject(theObj) (((ThingPtr)(theObj)) -> flags & ISOBJECT)
#define IsArray(theObj) (((ThingPtr)(theObj)) -> flags == REALARRAY)
#define IsObjArray(theObj) (((ThingPtr)(theObj)) -> flags == OBJECTARRAY)
#define IsList(theObj) (((ThingPtr)(theObj)) -> flags == LIST)
#define IsReal(theObj) (((ThingPtr)(theObj)) -> flags == REAL)
#define IsString(theObj) (((ThingPtr)(theObj)) -> flags == STRING)
#define IsInt(theObj) (((ThingPtr)(theObj)) -> flags == INTEGER)
#define IsPalette(theObj) (((ThingPtr)(theObj)) -> flags == PALETTE)
#define IsMatrix(theObj) (((ThingPtr)(theObj)) -> flags == MATRIX)
#define IsWindow(theObj) (((ThingPtr)(theObj)) -> flags == WINDOW)
#define IsPicture(theObj) (((ThingPtr)(theObj)) -> flags == PICTURE)
#define IsWindow(theObj) (((ThingPtr)(theObj)) -> flags == WINDOW)

/*NIL pointer, define so that it can cast to any pointer*/
#define NIL ((void *) 0)

#define CopyVar(d, s, v) SetVar(d, v, GetVar(s, v))

/*new operator*/
#define new(t)	((t *) malloc(sizeof(t)))

/*running variable, true iff running*/
extern int running;

/*running remote(ly) variable, true if running remotely*/
Bool runningRemote;

/*Demo mode, make text bigger and fatter*/
extern Bool demoP;

/*Temporary string*/
#define TEMPSTRSIZE	400
extern char tempStr[TEMPSTRSIZE + 1];

/*Fonts*/
#define TITLEFONT	1		/*Font for big titles*/
#define SUBTITLEFONT	2		/*Subtitle font*/
#define ICONFOREFONT	3		/*Font for icon foreground*/
#define ICONBACKFONT	4		/*Font for icon background*/
#define ICONSHADOWFONT	5		/*Font for icon shadow*/

/*Cursors*/
#define ARROWCURSOR	0		/*Arrow cursor*/
#define WATCHCURSOR	1		/*Watch cursor*/
#define IBEAMCURSOR	2		/*I-beam cursor*/
#define QUESTIONCURSOR	3		/*Question mark cursor*/
#define ICONCURSOR	4		/*Icon cursor*/

extern real missingData;		/*Missing data*/
#define PLUSINF		(1E37)		/*Plus infinity*/
#define MINUSINF	(-1E37)		/*Minus infinity*/

#define SCIANDATE       "November 27, 1991"
#define SCIANVERSION    "Version 0.40 beta"
#define AUTOLOG				/*Automatically log for error tracking*/

/*Screen sizes*/
#ifdef XMAXSCREEN
#define SCRWIDTH	XMAXSCREEN
#define SCRHEIGHT	YMAXSCREEN
#define VSCRWIDTH	XMAX170
#define VSCRHEIGHT	YMAX170
#else
#define SCRWIDTH	1280
#define SCRHEIGHT	1024
#define VSCRWIDTH	649
#define VSCRHEIGHT	484
#endif

#define WINBL		8
#define WINBR		8
#define WINBB		8
#define WINBT		32

/*Handy macros*/
#ifndef MIN
#define MIN(x, y)  ((x) < (y) ? (x) : (y))
#endif
#ifndef MAX
#define MAX(x, y)  ((x) > (y) ? (x) : (y))
#endif
#ifndef ABS
#define ABS(x) ((x) < 0 ? (-(x)) : (x))
#endif
#define MAG3(m) (sqrt((m)[0] * (m)[0] + (m)[1] * (m)[1] + (m)[2] * (m)[2]));
#define NORM3(m) {float z7; z7 = 1.0 / MAG3(m); m[0] *= z7; m[1] *= z7; m[2] *= z7;}

#ifdef FMATH
#define rsin(x) fsin(x)
#define rcos(x) fcos(x)
#define ratan2(x, y) fatan2(x, y)
#define rsqrt(x) fsqrt(x)
#else
#define fsin(x) sin(x)
#define fcos(x) cos(x)
#define fatan2(x, y) atan2(x, y)
#define fsqrt(x) sqrt(x)
#define rsin(x) sin(x)
#define rcos(x) cos(x)
#define ratan2(x, y) atan2(x, y)
#define rsqrt(x) sqrt(x)
#endif

#define SQ2     (1.414213562)
#define SQ22    (.707106)

#define GODLIKE
