/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>

#define MAX_BUFF 1024

#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif

int IsItText(fileName)
/* Can it be read as a text file */
/* return length , 0 if error*/
char *fileName;
{
FILE *fp;
unsigned char buff[MAX_BUFF];
register unsigned char *p;
register int x;
int num;
int length;

        if (!(fp = fopen(fileName,"r"))) {
                return(0);
                }
        length = 0;
        num = fread(buff,sizeof(char),MAX_BUFF,fp);
        while (num) {
                length += num;
                p = buff;
                for (x = 0; x< num; x++) {
                        if (*p++ > 127) {
                                /* Not ASCII */
                                fclose(fp);
                                return(0);
                                }
                        }
                num = fread(buff,sizeof(char),MAX_BUFF,fp);
                }
        fclose(fp);
        return(length);
}

int TextReadFile(fileName,textString)
/* return 0 on failure, file length on success */
char *fileName;
char **textString;
{
int length;
char errBuff[1024];
FILE *fp;
int num;

	if (!(length = IsItText(fileName))) {
		sprintf(errBuff,"Can't open text file %s\n",fileName);
		ErrMesg(errBuff);
		return(0);
		}
	
        if (!(fp = fopen(fileName,"r"))) {
		sprintf(errBuff,"Can't open text file %s\n",fileName);
		ErrMesg(errBuff);
                return(0);
                }
	if (!(*textString = (char *) MALLOC(length + 1))) {
		sprintf(errBuff,"Can't allocate enough memory for file %s\n",
				fileName);
		ErrMesg(errBuff);
		fclose(fp);
		return(0);
		}
        num = fread(*textString,sizeof(char),length,fp);

	fclose(fp);

	return(num);

} /* TextReadFile()  */




int TextWriteASCIIFile(fileName,textString)
char *fileName;
char *textString;
{
FILE *fp;
char errBuff[1024];
int num,length;

        if (!(fp = fopen(fileName,"w"))) {
		sprintf(errBuff,"Can't write to file %s\n",fileName);
		ErrMesg(errBuff);
                return(0);
                }

	length = strlen(textString);
        num = fwrite(textString,sizeof(char),length,fp);
	if (length != num) {
		sprintf(errBuff,"Error during write to file %s\n",fileName);
		ErrMesg(errBuff);
                return(0);
		}

	fclose(fp);
} /* TextWriteASCIIFile() */

