/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>

#include <X11/Intrinsic.h>

#include "doodle.h"
#include "view.h"
#include "viewer.h"


extern void DrawPoints();
extern int MySendDoodle();


extern POINT drawDoodle[];
extern long doodleLength;
extern GC invGC;
extern Display *myDpy;
extern Cdata *currentObject;


int start_x, end_x, start_y, end_y;


void
RubberBox(w)
	Widget w;
{
	int x, y;
	unsigned int width, height;

	if (start_x <= end_x)
	{
		x = start_x;
		width = end_x - start_x;
	}
	else
	{
		x = end_x;
		width = start_x - end_x;
	}
	if (start_y <= end_y)
	{
		y = start_y;
		height = end_y - start_y;
	}
	else
	{
		y = end_y;
		height = start_y - end_y;
	}
	XDrawRectangle(myDpy, XtWindow(w), invGC, x, y, width, height);
}


void
InitDrawBox(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	start_x = win_x;
	start_y = win_y;
	end_x = start_x;
	end_y = start_y;
	RubberBox(w);
	doodleLength = 0;
}


void
DrawBox(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if ((win_x != end_x)||(win_y != end_y))
	{
		RubberBox(w);
		end_x = win_x;
		end_y = win_y;
		RubberBox(w);
	}
}


void
DoneDrawBox(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	long	start;
	int     tmp, i;
	int     status;

	if (start_x > end_x)
	{
		tmp = start_x;
		start_x = end_x;
		end_x = tmp;
	}
	if (start_y > end_y)
	{
		tmp = start_y;
		start_y = end_y;
		end_y = tmp;
	}
	for (i = start_x; i <= end_x; i++)
	{
		drawDoodle[doodleLength].x = i;
		drawDoodle[doodleLength].y = start_y;
		doodleLength++;
		drawDoodle[doodleLength].x = i;
		drawDoodle[doodleLength].y = end_y;
		doodleLength++;
	}
	for (i = (start_y + 1); i <= (end_y - 1); i++)
	{
		drawDoodle[doodleLength].x = start_x;
		drawDoodle[doodleLength].y = i;
		doodleLength++;
		drawDoodle[doodleLength].x = end_x;
		drawDoodle[doodleLength].y = i;
		doodleLength++;
	}

	RubberBox(w);
	DrawPoints(V, V->cData, drawDoodle, 0, (doodleLength - 1),
		V->doodleColor, V->doodleWidth);

	/*
	 * Send Doodle
	 */
	status = MySendDoodle(V, V->doodleWidth, doodleLength, drawDoodle,
		True, True);
}

