/*
  File: wff2sgi.c
  Author: Jill Gemmill
  Last Modified: August 15, 1991
  Purpose: 
	   USAGE:
		wff2sgi [ -r ] <SGI_XXXX.rgb>

	   Converts a wff image to SGI image.

	   	If wff image is "I", filename should be XXX.bw

		If wff image is "RGB" or "RGBA" filename should be
		XXX.rgb

	   the wff file arrives via stdin
	   the sgi file is stored in a file,named as requested

	   the "-r" flag will store the image in RLE (run length
	   encoded) format, rather than VERBATIM, which is the
	   default.

 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>
#include "image.h"

#define HLIMIT 4096 /* ARBITRARY CONSTANT HARDCODED INTO Haeberli's IMAGE CODE*/

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-r] <SGI_XXXX.rgb>\n", RoutineName);
 }


static void
wff2sgi(fdIn,ImageName,rle)
 FILE *fdIn;
 char *ImageName;
 int rle;
 {
  IMAGE *image;
  FrameBufferType *FBin;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n;
  int xsize,ysize,zsize;
  unsigned short Pixel[100]; 
  char WhatBands[ValueLength];
  int  BitsPerBand;
  unsigned short rbuf[HLIMIT];
  unsigned short gbuf[HLIMIT];
  unsigned short bbuf[HLIMIT];

  
  /* GET A FRAMEBUFFER, STUFF THE WHOLE IMAGE INTO IT */
  FBin  = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBin)) return(-1);
  if (FAILURE == ReadImage(fdIn, FBin)) return(-1);
 
   /* WHAT KIND OF IMAGE IS THIS ? */
  GetColorSystem( FBin, WhatBands, &BitsPerBand );
  if (strcmp(WhatBands,"I") == 0) zsize = 1;
  else if (strcmp(WhatBands,"RGB") == 0 || strcmp(WhatBands,"RGBA") == 0) 
		zsize = 3;
  else
  {	   fprintf( stderr,
   "Sorry. This program only knows how to deal with RGB,RGBA and I images.\n" );
	 exit (1 );
  }
			     
  /* SIZE THE IMAGE */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin);  return; }
  xsize = Right-Left+1;
  ysize = Top-Bottom+1;

  if (xsize > HLIMIT)
  {	fprintf(stderr,
	"Sorry, Paul Haeberli says Your Image width must be <= %d\n",HLIMIT);
	exit(2);
  }

  /* WRITE HEADER OUT TO DISK */
  if (rle)
	image = iopen(ImageName,"w",RLE(1),3,xsize,ysize,zsize);
  else
	image = iopen(ImageName,"w",VERBATIM(1),3,xsize,ysize,zsize);
  

  for (y=Bottom;y<=Top;y++)
   {
    for(x=Left,n=0;x<=Right;x++,n++)
     {	(void) GetPixel(FBin,x,y,Pixel);
     	rbuf[n]=Pixel[0];
	if (zsize > 1)
	{	gbuf[n]=Pixel[1];
		bbuf[n]=Pixel[2];
	}
     }
     putrow(image,rbuf,y-Bottom,0);
     if (zsize > 1)
     {	putrow(image,gbuf,y-Bottom,1);
     	putrow(image,bbuf,y-Bottom,2);
     }
   }

   iclose(image);
  (void)CloseFB(&FBin);
 }



int main(argc,argv)
 int argc;
 char *argv[];
 {
  char *iname; 
  int encode = 0;
  RoutineName = argv[0];

  if (argc == 2)  iname = argv[1]; 
  else if (argc == 3) 
       {	if (*argv[1] != '-') { usage(); exit (-1); }
		iname = argv[2];
		encode = 1;
       }
  else
	{ usage(); exit(-1); }
 

  wff2sgi(stdin,iname,encode);

  fprintf(stderr,"\n%s: DONE             \n",RoutineName);
  exit (0);
}

