/*
 File: Ramp.c
 Authors: Tony DeRose,
          K.R. Sloan
 Last Modified: 30 January 1991
 Purpose:  Create a linear color ramp image.
*/
#include <stdio.h>
#include <strings.h>
#include "wff.h"

double atof();

int VERBOSE = 0;
static char *RoutineName;
static void 
usage()
 {
  fprintf(stderr,"Usage is:\n\t%s [-h][-v]\n",RoutineName);
  fprintf(stderr,"\t\t[-t rt gt bt]\n");
  fprintf(stderr,"\t\t[-b rb gb bb]\n\t\t[-x xsize][-y ysize]\n");
 }

/*
  Linearly interpolate between two values.
*/
double Blend(t0, t1, t, u0, u1)
 double t0, t1, t, u0, u1;
 {
  return (u0 + (t-t0)*(u1-u0)/(t1-t0));
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FILE *FileDescriptor;
  FrameBufferType *FrameBuffer;
  int Left, Bottom, Top, Right, BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  int xsize = 512, ysize=512;
  double rt=1.0, gt=1.0, bt=1.0;
  double rb=0.0, gb=0.0, bb=0.0;
  int x,y;
  unsigned short Pixel[3];
  int i,j;

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 't': if (3 > (argc-ArgsParsed)) {usage(); exit(-1);}
                rt = atof(argv[ArgsParsed++]);
                gt = atof(argv[ArgsParsed++]);
                bt = atof(argv[ArgsParsed++]);
                break;
      case 'b': if (3 > (argc-ArgsParsed)) {usage(); exit(-1);}
                rb = atof(argv[ArgsParsed++]);
                gb = atof(argv[ArgsParsed++]);
                bb = atof(argv[ArgsParsed++]);
                break;
      case 'x': if (1 > (argc-ArgsParsed)) {usage(); exit(-1);}
                xsize = atoi(argv[ArgsParsed++]);
                break;
      case 'y': if (1 > (argc-ArgsParsed)) {usage(); exit(-1);}
                ysize = atoi(argv[ArgsParsed++]);
                break;
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }

  FrameBuffer = (FrameBufferType *)0;
  OpenFB(&FrameBuffer);
  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  strcpy(WhatBands,"RGB"); BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stdout, FrameBuffer);
  
  for(i=0; i<ysize; i++)
   {
    Pixel[0] = (unsigned short)
               (0.5 + 255.0*Blend(0.0, (double)ysize-1.0, (double)i, rb, rt));
    Pixel[1] = (unsigned short)
               (0.5 + 255.0*Blend(0.0, (double)ysize-1.0, (double)i, gb, gt));
    Pixel[2] = (unsigned short)
               (0.5 + 255.0*Blend(0.0, (double)ysize-1.0, (double)i, bb, bt));
    for(j=0;j<xsize;j++) NextPixelOut(FrameBuffer, Pixel);
    wffFlush(FrameBuffer);
  }

  CloseFB(&FrameBuffer);

  exit(0);
 }


