/*
   File: Show.c
   Authors: K.R. Sloan, 
            Philip J. Schneider,
            James Painter,
	    John Kercheval
   Last Modified: 3 May 1991
   Purpose: Display a WFF image file in an X11 window
 */
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

Widget toplevel;

int VERBOSE;
char *RoutineName;

static void
usage()
 {  fprintf(stderr,"Usage is\n\t%s [-h][-v][-r]\n", RoutineName);  }

/* icon for application */

#define xshow_width 48
#define xshow_height 48
static char xshow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0x10, 0x00, 0x00, 0x00, 0x80, 0x01, 0x10, 0xff, 0xff, 0xff, 0x8f, 0x02,
   0x90, 0x00, 0x00, 0x00, 0x90, 0x04, 0x50, 0x00, 0x00, 0x00, 0xa0, 0x08,
   0x50, 0x00, 0x00, 0x00, 0xa0, 0x10, 0x50, 0x00, 0xfe, 0xff, 0xa1, 0x10,
   0x50, 0x00, 0x02, 0x00, 0xa1, 0x10, 0x50, 0x00, 0x72, 0x7e, 0xa1, 0x10,
   0x50, 0x00, 0x8a, 0x00, 0xa1, 0x10, 0x50, 0x00, 0x8a, 0x10, 0xa1, 0x10,
   0x50, 0x00, 0x8a, 0x1c, 0xa1, 0x10, 0x50, 0x00, 0x72, 0x12, 0xa1, 0x10,
   0x50, 0x00, 0x02, 0x11, 0xa1, 0x10, 0x50, 0x00, 0xc2, 0x10, 0xa1, 0x10,
   0x50, 0x00, 0xe2, 0x1f, 0xa1, 0x10, 0x50, 0x00, 0x02, 0x00, 0xa1, 0x10,
   0x50, 0x00, 0xfe, 0xff, 0xa1, 0x10, 0x50, 0x00, 0x00, 0x00, 0xa0, 0x10,
   0x50, 0x00, 0x00, 0x00, 0xa0, 0x10, 0x50, 0xfe, 0xff, 0xff, 0xa3, 0x10,
   0x50, 0x02, 0x00, 0x00, 0xa2, 0x10, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x10,
   0x50, 0xe2, 0xff, 0x0f, 0xa2, 0x10, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x10,
   0x50, 0xe2, 0x3f, 0x00, 0xa2, 0x10, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x10,
   0x50, 0xe2, 0xff, 0x00, 0xa2, 0x10, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x10,
   0x50, 0xe2, 0xff, 0x00, 0xa2, 0x10, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x10,
   0x50, 0xe2, 0xff, 0x1f, 0xa2, 0x10, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x10,
   0x50, 0x02, 0x00, 0x00, 0xa2, 0x08, 0x50, 0x02, 0x00, 0x00, 0xa2, 0x08,
   0x50, 0xfe, 0xff, 0xff, 0xa3, 0x04, 0x50, 0x00, 0x00, 0x00, 0xa0, 0x04,
   0x50, 0x00, 0x00, 0x00, 0xa0, 0x02, 0x90, 0x00, 0x00, 0x00, 0x90, 0x02,
   0x10, 0xff, 0xff, 0xff, 0x8f, 0x01, 0x10, 0x00, 0x00, 0x00, 0x80, 0x01,
   0xe0, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  Pixmap bitmap;
  Arg arglist[2];
  Display *display;
  unsigned long int fg,bg;
  int ArgsParsed = 0;
  int root = 0;

  RoutineName = argv[ArgsParsed++];

  /*
  **  Initialize the X11 toolkit.  This must be done before command
  **  parsing so that the X11 specific options can be stripped from
  **  the command line.
  */

  toplevel = XtInitialize( RoutineName, "XShow", NULL, 0, &argc, argv );

  /*  assign icon to application and give it a name */
  
  display = XtDisplay(toplevel);

  fg = 0; bg = 0;
  XtSetArg(arglist[0],XtNborderColor,&fg);
  XtSetArg(arglist[1],XtNbackground,&bg);

  XtGetValues(toplevel,arglist,2);
  bitmap = XCreatePixmapFromBitmapData(display,XRootWindow(display,0),
				       xshow_bits,xshow_width,xshow_height,
				       fg,bg,XDefaultDepth(display,0));
  XtSetArg(arglist[0],XtNiconPixmap,bitmap);
  XtSetArg(arglist[1],XtNiconName,"XShow");
  XtSetValues(toplevel,arglist,2);

  for(; ArgsParsed < argc; ArgsParsed++)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit(-1); }
    switch (argv[ArgsParsed][1])
     {
      default:
      case 'h': usage(); exit(-1);
      case 'v': VERBOSE = -1; break;
      case 'r': root = 1; break;
     }
    }

  X11ShowWFF(stdin, root);

  exit (0);
 }

