/*
 File: RatingHistory.c
 Author: K.R. Sloan
 Last Modified: 10 December 1992
 Purpose: generate graph of rating history
 */

#include <stdio.h>
#include <string.h>

int VERBOSE = 0;

static char *RoutineName;

static void usage()
 {
  fprintf(stderr,"usage is:\n\t%s [-h][-v][-y m M][-r m M]\n",
             RoutineName);
 }

static void FatalError(s)
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }


#define MAXN 2048
static int Year[MAXN], minYear=10000, maxYear=0;
static int Month[MAXN];
static int Rating[MAXN],minRating=10000,maxRating=0;
static int nRatings = 0;

static double RealDate(Year,Month)
 int Year, Month;
 {
  return (((double)Year) + (((double)Month-1.0)/12.0));
 }

static void ReadRatings(s)
 FILE *s;
 {
  int i;

  for(i=0;;i++)
   {
    if (3 != fscanf(s," %d %d %d",
                   &Year[i],&Month[i],&Rating[i]))
     {
      nRatings = i; return;
     }
    if      (Rating[i]<minRating) minRating=Rating[i];
    else if (Rating[i]>maxRating) maxRating=Rating[i];
    if      (Year[i]<minYear) minYear=Year[i];
    else if (Year[i]>maxYear) maxYear=Year[i];
   }
 }

static void PlotGraph(s)
 FILE *s;
 {
  int bottom, top;
  double left, right;
  int tic;
  int i,r;

  bottom = (minRating-1)/200; bottom *= 200;
  top    = (maxRating   /200)+1; top    *= 200;
  left   = RealDate(minYear,1);
  right  = RealDate(maxYear+1,1),

  fprintf(s,"%%!\n%%%% created by %s\n",RoutineName);
  fprintf(s,"sgpMonochromeDisplay sgpInit\n");
  fprintf(s,"1 sgpGrayLevel\n");
  fprintf(s,"sgpClearScreen\n");
  fprintf(s,"0 sgpGrayLevel\n");

  fprintf(s,"0.1 0.1 0.9 0.9 sgpSetViewport\n");
  fprintf(s,"%lf %d %lf %d sgpSetWindow\n",
             left,
             bottom,
             right, 
             top);

  for(r=bottom;r<=top;r +=200)
   fprintf(s,"[%lf %d][%lf %d] sgpLine\n",
              left, r, right, r);

  for(tic=minYear;tic<=maxYear+1;tic++)
   {
    fprintf(s,"[ %lf %d ] [ %lf %d ] sgpLine\n",
               RealDate(tic,1), bottom,
               RealDate(tic,1), bottom+50);
   }

  for(i=1;i<nRatings;i++)
   {
    fprintf(s,"[ %lf %d ] [ %lf %d ] sgpLine\n",
               RealDate(Year[i-1],Month[i-1]), Rating[i-1],
               RealDate(Year[i  ],Month[i  ]), Rating[i  ]);
   }
  fprintf(s,"sgpQuit\n");
 }

int main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      case 'r': if (2 > (argc-ArgsParsed)) {usage(); exit(-1);}
                minRating = atoi(argv[ArgsParsed++]);
                maxRating = atoi(argv[ArgsParsed++]);
                break;
      case 'y': if (2 > (argc-ArgsParsed)) {usage(); exit(-1);}
                minYear = atoi(argv[ArgsParsed++]);
                maxYear = atoi(argv[ArgsParsed++]);
fprintf(stderr,"years = [%d, %d]\n",minYear,maxYear);

                break;
      default:
      case 'h': usage(); exit(-1);
     }
   }

  ReadRatings(stdin);

  PlotGraph(stdout);  

  exit(0); 
 }


