/*
  File: DEVICE.h
  Author: K.R. Sloan
  Last Modified: 10 February 1991
  Purpose: definitions for the generic graphics device used by SGP
           all parameters are ints (except R,G,B to devColorCode)
           all routines return 0 == success, other == failure

           Many of the devices produce an OutputStream (e.g., a meta-file,
           or an image file).  devOutputStream is initialized by devInit
           (almost certainly to stdout) and may be changed by client
           programs at their own peril.  

           Devices which actually drive real displays generally do not
           use devOutputStream.  They may produce output on stderr.

           This version includes devPick.  Devices without locator devices
           (e.g., mouse, tablet,...) should simulate one by prompting
           the user to type in numbers.  Boring, but OK for testing.

           For the truly lazy implementor...have devPick simply fail!
 */


/*
    These must be initialized by devInit()
 */
extern int devLeft, devBottom, devRight, devTop;
extern int devClipL, devClipB, devClipR, devClipT;
extern int devCurrentColor;
extern FILE *devOutputStream;
extern double devAspectRatio;

/*
   devInit(color,stream) initializes the display, 
   loading color maps if necessary
   There are two modes: color (1) and mono (0).
 */
extern int devInit();

/*
   devClose() makes sure that all operations have completed, and
   closes the display.
 */
extern int devClose();

/*
  devSetClipWin(L,B,R,T) establishes a clipping window
 */
extern int devSetClipWin();

/*
 devClearScreen(color) fills the entire screen with a particular color
 */
extern int devClearScreen();

/*
   the following routines draw primitive shapes on the physical device
   All of them clip against the device's clipping window.
   All of them paint in the device's current color
 */

/*
  devLine(x0, y0, x1, y1) draws a line
 */
extern int devLine();

/*
 devRect(L, B, R, T) fills a rectangle
 */
extern int devRect();

/*
 devDisc(x, y, r) fills a disc
 */
extern int devDisc();

/*
 devCircle(x, y, r) draws a circle
 */
extern int devCircle();

/*
 devSolidTriangle(x0, y0, x1, y1, x2, y2) fills a triangle
 */
extern int devSolidTriangle();

/*
 devShadeTriangle(x0, y0, c0, x1, y1, c1, x2, y2, c2) shades a triangle
   with color codes specified at each vertex
 */
extern int devShadeTriangle();

/*
 devSetColor(color) establishes the current color
 */
extern int devSetColor();

/*
   devColorCode(R, G, B) color returns a framebuffer value
   R,G,B must all lie in [0.0, 1.0]

   if your device uses a color map, you may need to solve the 
     "nearest-neighbor" problem...
 */ 
extern int devColorCode();

/*
  devColorDecode(code, &R, &G, &B) generates r,g,b values in [0.0, 1.0] 
 */
extern int devColorDecode();

/*
  devPick(&x,&y,&button) returns:
    x,y     - location in device coordinates
    button  - 1 if pressed, 0 otherwise
 */
extern int devPick();

/*
  And....that's it!
 */
