/*
  File: EditFunctions.c
  Author: Cheryl Buck
  Last Modified: 13 March 1990
  Purpose: routines used to rewrite editted Section - delete points, insert 
           points, etc.
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "3D.h"
#include "ContourEditor.h"
#include <TypeDefinitions.h>
#include "Contours.h"

static double TooFarApart = 0.080;
static sgpPointType Origin = {0.0, 0.0};

extern int FindClosestPoint(SelectedPoint, Closest, ASection)
  sgpPointType SelectedPoint;
  PointLocator *Closest;
  Section *ASection;
{
 sgpPointType WorldDistance, ScreenOrigin, ScreenDistance;
 double Distance, ClosestDistance;
 int Npts;

 if (NULL != ASection->TheContours)
  {
   int i;
   Closest->TheContour = 0;
   Closest->ThePoint = 0;

   ClosestDistance = (sqrt
                       (pow(ASection->TheContours[0].ContourPoints->P[0].x-  
                         SelectedPoint.x, 2.0) + 
                        pow(ASection->TheContours[0].ContourPoints->P[0].y -
                              SelectedPoint.y, 2.0)));

   for(i=0; i<ASection->NContours; i++)
     { int j;

       Npts = ASection->TheContours[i].ContourPoints->n ;
       for(j=0; j<Npts; j++)
        {

          Distance = (sqrt
                       (pow(ASection->TheContours[i].ContourPoints->P[j].x-  
                             SelectedPoint.x, 2.0) + 
                        pow(ASection->TheContours[i].ContourPoints->P[j].y-  
                          SelectedPoint.y, 2.0)));
          if (Distance < ClosestDistance)
            {
              Closest->ThePoint = j; Closest->TheContour = i;
              ClosestDistance = Distance;
            }
        }
     } 
    sgpWorldToScreen(Origin, &ScreenOrigin);
    WorldDistance.x = ClosestDistance; WorldDistance.y = 0.0;
    sgpWorldToScreen(WorldDistance, &ScreenDistance);

    if ((ScreenDistance.x - ScreenOrigin.x) > TooFarApart)
      return(0);
    else
      return(1);
  }
}

extern void DeleteContourFromSection(WhatPoint, ASection)
  PointLocator WhatPoint;
  Section *ASection;

{
 int i, NConts, ContourNum;

 ContourNum = WhatPoint.TheContour;
 NConts = ASection->NContours ; 

 for(i=ContourNum; i<NConts - 1 ; i++)
      ASection->TheContours[i] = ASection->TheContours[i + 1];

 ASection->NContours = NConts - 1;
}


extern void DeletePointFromSection(WhatPoint, ASection, KeepSection)
  PointLocator WhatPoint;
  Section *ASection;
  int *KeepSection;

{
 int i, Npts, ContourNum, PointNum;

 PointNum = WhatPoint.ThePoint;
 ContourNum = WhatPoint.TheContour;
 Npts = ASection->TheContours[ContourNum].ContourPoints->n ; 

 for(i=PointNum; i<Npts-1 ; i++)
   {
      ASection->TheContours[ContourNum].ContourPoints->P[i].x = 
         ASection->TheContours[ContourNum].ContourPoints->P[i+1].x;
      ASection->TheContours[ContourNum].ContourPoints->P[i].y = 
         ASection->TheContours[ContourNum].ContourPoints->P[i+1].y;
      ASection->TheContours[ContourNum].ContourPoints->P[i].z = 
         ASection->TheContours[ContourNum].ContourPoints->P[i+1].z;
   } 
 ASection->TheContours[ContourNum].ContourPoints->n = Npts - 1;

 if (ASection->TheContours[ContourNum].ContourPoints->n == 0)
     DeleteContourFromSection(WhatPoint, ASection);

 if (ASection->NContours == 0)
     *KeepSection = 0;
}


extern void AddPointToSection(WhatPoint, ASection, NewPoint)
  PointLocator WhatPoint;
  Section *ASection;
  sgpPointType NewPoint;

{
  int i, Npts, ContourNum, PointNum;
  double ZValue; 
  PointsType *NewContourPoints;

  PointNum = WhatPoint.ThePoint; 
  ContourNum = WhatPoint.TheContour;
  Npts = ASection->TheContours[ContourNum].ContourPoints->n ;
  ZValue = ASection->TheContours[ContourNum].ContourPoints->P[PointNum].z;

  Npts = Npts + 1;
  NewContourPoints = NewPoints(Npts);
  if (NULL == NewContourPoints)
    {
      (void) fprintf(stderr, "Insufficient memory, AddPointToSection\n");
      exit(-1);
    }

  for(i=0; i<=PointNum; i++)
    {
      NewContourPoints->P[i].x = 
         ASection->TheContours[ContourNum].ContourPoints->P[i].x;
      NewContourPoints->P[i].y = 
         ASection->TheContours[ContourNum].ContourPoints->P[i].y;
      NewContourPoints->P[i].z = ZValue; 
    } 

  NewContourPoints->P[PointNum].x = NewPoint.x;
  NewContourPoints->P[PointNum].y = NewPoint.y;
  NewContourPoints->P[PointNum].z = ZValue;

  for(i=PointNum; i< Npts - 1; i++)
    {
      NewContourPoints->P[i+1].x = 
         ASection->TheContours[ContourNum].ContourPoints->P[i].x;
      NewContourPoints->P[i+1].y = 
         ASection->TheContours[ContourNum].ContourPoints->P[i].y;
      NewContourPoints->P[i+1].z = ZValue;
    } 

  FreePoints(ASection->TheContours[ContourNum].ContourPoints);
  ASection->TheContours[ContourNum].ContourPoints = NewContourPoints;
}


extern void MovePointInSection(WhatPoint, ASection, NewPoint)
  PointLocator WhatPoint;
  Section *ASection;
  sgpPointType NewPoint;
{
 int ContourNum, PointNum;

 PointNum = WhatPoint.ThePoint;
 ContourNum = WhatPoint.TheContour;
 ASection->TheContours[ContourNum].ContourPoints->P[PointNum].x = NewPoint.x;
 ASection->TheContours[ContourNum].ContourPoints->P[PointNum].y = NewPoint.y;
}


static int ProcessLocalAdjacency(TheAdjList, LocalPoint, AdjPoint, ASection, PrevOrNext)
   Adjacency *TheAdjList;
   PointLocator LocalPoint, *AdjPoint;
   Section *ASection;
   int PrevOrNext;   /* 0 - Previous ; 1 - Next */
{
  int DONE, FOUND, EqualStrings;
  Adjacency *TheAdjacency, *FirstAdjacency, *PrevAdjacency;

  DONE = 0; FOUND = 0;
  PrevAdjacency = NULL;
  TheAdjacency = TheAdjList;
  FirstAdjacency = TheAdjacency;

  while ((! DONE) && (! FOUND))
    {
     if (TheAdjacency->LocalIndex == LocalPoint.ThePoint)
       {
         int k;
          
         DONE = 1; FOUND = 1;
         AdjPoint->ThePoint = TheAdjacency->AdjacentIndex;
         AdjPoint->TheContour = -1;
         for (k = 0; k<ASection->NContours; k++)
           {
            EqualStrings = strcmp(ASection->TheContours[k].Name,
                                        TheAdjacency->Name);
            if (0 == EqualStrings)
             {
              AdjPoint->TheContour = k;
              if (PrevAdjacency == NULL)
                {
                 if (PrevOrNext == 0)
		   ASection->TheContours[LocalPoint.TheContour].AdjContPrev = NULL;
		 else
		   ASection->TheContours[LocalPoint.TheContour].AdjContNext = NULL;
	       }
               else
                {
                  TheAdjacency->prev->next = TheAdjacency->next;
                  TheAdjacency->next->prev = TheAdjacency->prev;
                }
             }
           }
         if (AdjPoint->TheContour == -1)
           {
             fprintf(stderr, "Error in Adjacency naming.\n");
             exit(-1);
           }
      }

      PrevAdjacency = TheAdjacency;
      TheAdjacency = TheAdjacency->next;
      if (TheAdjacency == FirstAdjacency)
         DONE = 1;
   }
  return (FOUND);
}


extern int HandleLocalAdjacencies(LocalPoint, AdjPoint, ASection)
  PointLocator LocalPoint, *AdjPoint;
  Section *ASection;

{
  int FOUND = 0;

  if ((ASection->TheContours[LocalPoint.TheContour].AdjContNext == NULL) &&
      (ASection->TheContours[LocalPoint.TheContour].AdjContPrev == NULL))
    return (0);
  else
   {
     if (!(ASection->TheContours[LocalPoint.TheContour].AdjContNext == NULL))
       FOUND = ProcessLocalAdjacency(ASection->TheContours[LocalPoint.TheContour].AdjContNext, LocalPoint, AdjPoint, ASection, 1);

     if (!(ASection->TheContours[LocalPoint.TheContour].AdjContPrev == NULL))
       FOUND = ProcessLocalAdjacency(ASection->TheContours[LocalPoint.TheContour].AdjContPrev, LocalPoint, AdjPoint, ASection, 0);
   }
 return (FOUND);

}



static int ProcessAdjacentAdjacency(TheAdjList, LocalPoint, AdjPoint, ASection,                                       ContourNum, PrevOrNext)
   Adjacency *TheAdjList;
   PointLocator *LocalPoint, AdjPoint;
   Section *ASection;
   int ContourNum, PrevOrNext;  /* 0 - Prev; 1 - Next */
{
  int DONE, FOUND, EqualStrings;
  Adjacency *TheAdjacency, *FirstAdjacency, *PrevAdjacency;

  DONE = 0; FOUND = 0;
  PrevAdjacency = NULL;
  TheAdjacency = TheAdjList;
  FirstAdjacency = TheAdjacency;

  while ((!DONE) && (!FOUND))   /* check to see if same point number */
   {
    if (AdjPoint.ThePoint == TheAdjacency->AdjacentIndex)
     {
       /* see if the names of the contours match */
       EqualStrings =  strcmp(ASection->TheContours[AdjPoint.TheContour].Name,
              TheAdjacency->Name);
       if (EqualStrings == 0)
        {
         LocalPoint->TheContour = ContourNum;
         LocalPoint->ThePoint = TheAdjacency->LocalIndex;
         if (PrevAdjacency == NULL)
          {     
            if (PrevOrNext == 0)
              ASection->TheContours[ContourNum].AdjContPrev = NULL;
            else
	      ASection->TheContours[ContourNum].AdjContNext = NULL;
          }     
         else
          {
           TheAdjacency->prev->next = TheAdjacency->next;
           TheAdjacency->next->prev = TheAdjacency->prev;
           }
         FOUND = 1; DONE = 1;
        }
      }
     if (! FOUND)  
      {
        PrevAdjacency = TheAdjacency;
        TheAdjacency = TheAdjacency->next;
	if (TheAdjacency == FirstAdjacency)
           DONE = 1;
       }
  }
  return (FOUND);
}


extern int HandleAdjacentAdjacencies(AdjPoint, LocalPoint, ASection)
  PointLocator AdjPoint, *LocalPoint;
  Section *ASection;

{
  int CNum, FOUND, EqualStrings;
  
  FOUND = 0; CNum = 0;

  while ( (CNum < ASection->NContours) && (! FOUND))
    {
    /* only look in contours the adjacent point is not in */
     EqualStrings = strcmp(ASection->TheContours[CNum].Name,
         ASection->TheContours[AdjPoint.TheContour].Name);
     if (EqualStrings != 0)
       {
        if (! (ASection->TheContours[CNum].AdjContPrev == NULL))
         FOUND = 
         ProcessAdjacentAdjacency(ASection->TheContours[CNum].AdjContPrev,
                               LocalPoint, AdjPoint, ASection, CNum, 0);

         if (! (ASection->TheContours[CNum].AdjContNext == NULL))
          FOUND = 
             ProcessAdjacentAdjacency(ASection->TheContours[CNum].AdjContNext,
				      LocalPoint, AdjPoint, ASection, CNum, 1);
    
      }
     CNum = CNum + 1;
    }      

  return (FOUND);
}

extern void RenumberLocal(TheAdjList, WhatPoint, InsOrDel)
     Adjacency *TheAdjList;
     PointLocator WhatPoint;
     int InsOrDel;

{
  int DONE;
  Adjacency *TheAdjacency, *FirstAdjacency;

  DONE = 0;
  TheAdjacency = TheAdjList;
  FirstAdjacency = TheAdjacency;
     
  while (! DONE)
    {
     if (TheAdjacency->LocalIndex >= WhatPoint.ThePoint)
      {
        if (InsOrDel == 1)
       TheAdjacency->LocalIndex = (TheAdjacency->LocalIndex + 1);
        else
       TheAdjacency->LocalIndex = (TheAdjacency->LocalIndex - 1);
      }

    TheAdjacency = TheAdjacency->next;
    if (TheAdjacency == FirstAdjacency)
      DONE = 1;
   }
}


extern void RenumberAdjacent(TheAdjList, WhatPoint, InsOrDel, ASection)
     Adjacency *TheAdjList;
     PointLocator WhatPoint;
     int InsOrDel;
     Section *ASection;

{
  int DONE, EqualStrings;
  Adjacency *TheAdjacency, *FirstAdjacency;

  DONE = 0;
  TheAdjacency = TheAdjList;
  FirstAdjacency = TheAdjacency;
     
  while (! DONE)
    {
     EqualStrings =  strcmp(ASection->TheContours[WhatPoint.TheContour].Name,
                     TheAdjacency->Name);
     if (EqualStrings == 0)
       if (TheAdjacency->AdjacentIndex >= WhatPoint.ThePoint)
         {
           if (InsOrDel == 1)
          TheAdjacency->AdjacentIndex = (TheAdjacency->AdjacentIndex + 1);
           else
          TheAdjacency->AdjacentIndex = (TheAdjacency->AdjacentIndex - 1);
         }

    TheAdjacency = TheAdjacency->next;
    if (TheAdjacency == FirstAdjacency)
      DONE = 1;
   }
}


extern void RenumberAdjacencies(WhatPoint, InsOrDel, ASection)
     PointLocator WhatPoint;
     int InsOrDel;
     Section *ASection;
{ 
  int i, EqualStrings;

  if (ASection->TheContours[WhatPoint.TheContour].AdjContNext != NULL) 
    RenumberLocal(ASection->TheContours[WhatPoint.TheContour].AdjContNext, 
             WhatPoint, InsOrDel);

  if (ASection->TheContours[WhatPoint.TheContour].AdjContPrev != NULL)
    RenumberLocal(ASection->TheContours[WhatPoint.TheContour].AdjContPrev,
             WhatPoint, InsOrDel);

  for (i = 0; i < ASection->NContours; i++)
    {
      EqualStrings = 
     strcmp(ASection->TheContours[WhatPoint.TheContour].Name,
          ASection->TheContours[i].Name);
      if (EqualStrings != 0) /* if its a different contour */
     {
       if (ASection->TheContours[i].AdjContNext != NULL)
         RenumberAdjacent(ASection->TheContours[i].AdjContNext,
                     WhatPoint, InsOrDel, ASection);
       if  (ASection->TheContours[i].AdjContPrev != NULL)
         RenumberAdjacent(ASection->TheContours[i].AdjContPrev,
                     WhatPoint, InsOrDel, ASection);
        }
    }
}


extern int WriteNewFile(OldFile, NewFile, CurrentSectionNum, CurrentSection, 
                         MaxSections, SData, KeepSection)
  FILE *OldFile, *NewFile;
  int CurrentSectionNum, MaxSections, KeepSection;
  Section *CurrentSection;
  SectionSize *SData;
{


  int Offset, SeekStatus, i;
  Section *ASection;

  if (CurrentSectionNum > 0) 
  {
    Offset = SData[0].StartingLocation;
    SeekStatus = fseek(OldFile, Offset, 0);
    if (-1 == SeekStatus) {perror("Bad seek"), exit(-1); }
  }
  ASection = (Section *) malloc(sizeof(Section));

/* rewrite all section up to one changed */
  for (i=0; i<CurrentSectionNum; i++)
   {
    ReadSection(OldFile, ASection);
    WriteSection(NewFile, ASection);
    }
  if (KeepSection)
     WriteSection(NewFile, CurrentSection);

  if (CurrentSectionNum < MaxSections)
    {
     Offset = SData[CurrentSectionNum + 1].StartingLocation;
     SeekStatus = fseek(OldFile, Offset, 0);
     if (-1 == SeekStatus) {perror("Bad seek"), exit(-1); }
     for (i=(CurrentSectionNum + 1); i <= MaxSections; i++)
      {
        ReadSection(OldFile, ASection);  
        WriteSection(NewFile, ASection);
      }
   }
}
