/* 
  File: SurfaceArea.c
  Authors: James Painter, David Meyers
  Last Modified: 22 November 1989
  Purpose: Metric function for the search. SurfaceArea computes the area of
           a tile.
 */

#include <TypeDefinitions.h>
#include <Contours.h>
#include <Vector.h>

REAL SurfaceArea( P1, P2, P3 )
 PointType *P1, *P2, *P3;

 {
   VectorType V1, V2, V3;

   minus( P1, P2, &V1 );
   minus( P1, P3, &V2 );
   cross( &V1, &V2, &V3 );
   return magn( &V3 )/2.;
 }



