/*
  File: OutputStuff.c
  Author: David Meyers
  Last Modified: 22 May 1990
  Purpose: Ouptut routines for Contours package.
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <TypeDefinitions.h>
#include <Aggregates.h>
#include <BitArray.h>

/**************************************************************************/

/*
 *  Writes out the triangulated surface for one pair of contours
 *  in a format acceptable to the rendering pipeline.
 */
void WriteSurface (contour1, contour2, CD1, CD2,
		   start1, start2, TriangleNumber,
		   Section1, Section2,
		   directions)
 PointsType *contour1, *contour2;
 ContourDescriptor *CD1, *CD2;
 int start1, start2, *TriangleNumber;
 Section *Section1, *Section2;
 BitArray directions;
 {
  int i, n1, n2, nSteps, index1, index2, last1, last2;
  char name1[80], name2[80], name3[80];

  n1 = contour1->n;
  n2 = contour2->n;

  index1 = start1;
  index2 = start2;
  if((1 < n1) && (1 < n2))
   {
    nSteps = n1 + n2;
    for ( i=0; i < nSteps; i++ ) 
     {
      (void) fprintf(stdout," ");
      if (TestBit( i, directions ) )  /* Step along top contour */
       {
	last1 = index1;
	index1 = ++index1 % n1;
	(void) strcpy(name1, PointName(Section1, last1, CD1));
	(void) strcpy(name2, PointName(Section2, index2, CD2));
	(void) strcpy(name3, PointName(Section1, index1, CD1));
	(void) fprintf (stdout, "t%d = [%s, %s, %s];\n",
			*TriangleNumber + i, name1, name2, name3);
       }
      else   /* Step along bottom contour */
       {
	last2 = index2;
	index2 = ++index2 % n2;
	(void) strcpy(name1, PointName(Section1, index1, CD1));
	(void) strcpy(name2, PointName(Section2, last2, CD2));
	(void) strcpy(name3, PointName(Section2, index2, CD2));
	(void) fprintf (stdout, "t%d = [%s, %s, %s];\n",
			*TriangleNumber + i, name1, name2, name3);
       }
     }
   }
  else /* special case when only one point in one contour */
   {
    nSteps = n1 + n2 - 1;
    if(1 == n1)
     {
      (void) strcpy(name1, PointName(Section1, index1, CD1));
      for(i=0; i<nSteps; i++)
       {
	last2 = index2;
	index2 = ++index2 % n2;
	(void) strcpy(name2, PointName(Section2, last2, CD2));
	(void) strcpy(name3, PointName(Section2, index2, CD2));
	(void) fprintf (stdout, "t%d = [%s, %s, %s];\n",
			*TriangleNumber + i, name1, name2, name3);
       }
     }
    else
     {
      (void) strcpy(name2, PointName(Section2, index2, CD2));
      for(i=0; i<nSteps; i++)
       {
	last1 = index1;
	index1 = ++index1 % n1;
	(void) strcpy(name1, PointName(Section1, last1, CD1));
	(void) strcpy(name3, PointName(Section1, index1, CD1));
	(void) fprintf (stdout, "t%d = [%s, %s, %s];\n",
			*TriangleNumber + i, name1, name2, name3);
       }
     }
   }
  *TriangleNumber += nSteps;
  (void) fflush(stdout);
 }

/**************************************************************************/

extern void WriteMesh(TriangleNumber)
 int TriangleNumber;
{
 int i;

 (void) fprintf(stdout,"mesh = {\n");
 for (i=0; i<TriangleNumber-1; i++)
  {
   (void) fprintf(stdout, "  t%d,\n", i);
  }
 (void) fprintf(stdout, "  t%d\n", i);
 (void) fprintf(stdout," };\n");
 (void) fflush(stdout);
}

/**************************************************************************/

extern void WritePoints(TheSection, TheFile)
 Section *TheSection;
 FILE *TheFile;
{
 int i, j;
 char NameString[80];

 for (i=0; i<TheSection->NContours; i++)
  {
   (void) strcpy(NameString, TheSection->Name);
   (void) strcat(NameString, TheSection->TheContours[i].Name);
   for (j=0; j<TheSection->TheContours[i].ContourPoints->n; j++)
    {
     if(Find(TheSection, i, j, NameString))
      {
       /*
	 This point needs to be done separately. Fix up the NameString info
	 since Find sets its value when successful, and we are going to
	 defer writing out this point until later.
	*/
       (void) strcpy(NameString, TheSection->Name);
       (void) strcat(NameString, TheSection->TheContours[i].Name);
      }
     else
      {
       (void) fprintf(TheFile, "%s%d = (Point . (pos . [%f, %f, %f]));\n",
		      NameString, j,
		      TheSection->TheContours[i].ContourPoints->P[j].x,
		      TheSection->TheContours[i].ContourPoints->P[j].y,
		      TheSection->TheContours[i].ContourPoints->P[j].z);
      }
    }
  }
 /* 
   Now write out the special points shared by two contours.
  */
 for(i=0; i<TheSection->Last; i++)
  {
   int j, k;

   j = TheSection->TheIndex[i].FirstContour;
   k = TheSection->TheIndex[i].FCPoint;

   (void) fprintf(TheFile, "%s = (Point . (pos . [%f, %f, %f]));\n",
		  TheSection->TheIndex[i].Name,
		  TheSection->TheContours[j].ContourPoints->P[k].x,
		  TheSection->TheContours[j].ContourPoints->P[k].y,
		  TheSection->TheContours[j].ContourPoints->P[k].z);
  }
 (void) fflush(TheFile);
}

/**************************************************************************/
