/*
** File: NewPath.h
** Purpose: Allocate memory for a new path.
** Author: James Painter, David Meyers
** Last Modified: 8 November 1989
*/

#include <stdio.h>
#include <TypeDefinitions.h>
#include "TorGraph.h"
extern char *malloc();
extern void free();

PathType *NewPath( NRows, NColumns )
 {
  PathType *P;

  if (! (P = (PathType *) malloc( sizeof(PathType))))
   {
    (void) fprintf( stderr, "NewPath.  No memory.\n" );
    return (PathType *) NULL;
   }
  P->Rows = NRows;
  P->Columns = NColumns;
  P->LeavesRowInCol = NULL;
  P->LeavesColInRow = NULL;
  if (! (P->LeavesRowInCol = (int *)
	 malloc( (unsigned) (2*NRows*sizeof(int)))))
   {
    (void) fprintf( stderr, "NewPath:  No memory.\n");
    DisposePath( P );
    return( PathType *) NULL;
   }
  if (! (P->LeavesColInRow = (int *) malloc( (unsigned) (2*NColumns*sizeof(int)))))
   {
    (void) fprintf( stderr, "NewPath:  No memory.\n");
    DisposePath( P );
    return( PathType *) NULL;
   }
  return P;
 }


void DisposePath( P )
PathType *P;
 {
  if (P == NULL) return;

  if (P->LeavesColInRow != NULL) free( (char *) P->LeavesColInRow );
  if (P->LeavesRowInCol != NULL) free( (char *) P->LeavesRowInCol );
  free( (char *) P );
 }

