/*
  File: FilterContours.c
  Authors: K.R. Sloan, David Meyers   
  Last Modified: 6 March 1991
  Purpose: Read a section file and filter each contour
           a) by distance
           b) by fitting a piecewise cubic spline and evaluating
              each segment at 0, 1/3, 2/3
 */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "TypeDefinitions.h"
#include "Contours.h"
#include "InputStuff.h"
#include "SectionOutput.h"
#include "2d.h"

extern char *malloc();
extern double atof();
extern void exit();

int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  (void) fprintf(stderr,
  "Usage is\n\t%s [-h][-v]\n",
                 RoutineName);
 }

typedef Point2 *BezierCurve;
Point2 Bezier();
int DrawBezierCurve(n, Curve)
 int n;
 BezierCurve Curve;
 {
  int i;
  Point2 P;

  for(i=0;i<n;i++)
   {
    P = Bezier(n,Curve,(double)i/(double)n);
    fprintf(stderr,"  [%f,%f]\n",P.x, P.y);
   }
 }

static int FilterContourPoints(ContourPoints,Tolerance2)
 PointsType *ContourPoints;
 double Tolerance2;
 {
  int n;
  int i,j;
  Point2 *d;
  Vector2 tHat1, tHat2;
  double l;

  n = ContourPoints->n;
  j = 0;
  for(i=1;i<n;i++)
   {
    double dx,dy,d;
    
    dx = ContourPoints->P[i].x - ContourPoints->P[j].x;    
    dy = ContourPoints->P[i].y - ContourPoints->P[j].y;    
    d = dx*dx + dy*dy;

    if (d > Tolerance2)
     {
      ContourPoints->P[++j].x = ContourPoints->P[i].x;
      ContourPoints->P[  j].y = ContourPoints->P[i].y;
     }
   }
  ContourPoints->n = ++j;

  /*
    now, fit a cubic (but ignore the output right now - debugging...
   */

  n = ContourPoints->n;
  d = (Point2 *)malloc(n*sizeof(Point2));
  for(i=0;i<n;i++)
   {
    d[i].x = ContourPoints->P[i].x;
    d[i].y = ContourPoints->P[i].y;
   }

  tHat1.x = ContourPoints->P[1].x - ContourPoints->P[n-1].x;
  tHat1.y = ContourPoints->P[1].y - ContourPoints->P[n-1].y;
  l = 2.0 * sqrt(tHat1.x*tHat1.x + tHat1.y*tHat1.y);
  tHat1.x /= l;         tHat1.y /= l;
  tHat2.x = -tHat1.x;   tHat2.y = -tHat1.y;
  fprintf(stderr,"Begin Fitting Cubic\n");
  FitCubic(d, 0, n-1, tHat1, tHat2, 0.5*sqrt(Tolerance2));

  /*
     points will be emitted by DrawBezierCurve, above...
   */
  fprintf(stderr,"End Fitting Cubic\n");
 }

int main(argc, argv)
 int argc;
 char *argv[];
 {
  static int ArgsParsed = 0;
  static double Tolerance2 = 0.0000000001;
  Section *TheSection;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 't': if (1 < (argc-ArgsParsed)) {usage(); exit(-1);}
                Tolerance2 = atof(argv[ArgsParsed++]);
                Tolerance2 = Tolerance2*Tolerance2;
                break;
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }   

  TheSection = (Section *) malloc(sizeof(Section));
  ReadSection(stdin, TheSection);

  while(NULL != TheSection->TheContours)
   {
    int i;

    for (i=0; i<TheSection->NContours; i++)
     {
      FilterContourPoints(TheSection->TheContours[i].ContourPoints,Tolerance2);
     }
    WriteSection(stdout, TheSection);
    ReadSection(stdin, TheSection);
   }
  if (VERBOSE) (void) fprintf(stderr,"-30-\n");
  exit(0);
 }


